/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.env.Sys;
import io.basc.framework.factory.InheritableThreadLocalConfigurator;
import io.basc.framework.io.CrossLanguageSerializer;
import io.basc.framework.io.JavaSerializer;
import io.basc.framework.io.Serializer;
import io.basc.framework.io.SerializerException;
import io.basc.framework.json.JsonSerializer;

public final class SerializerUtils {
    private static final InheritableThreadLocalConfigurator<CrossLanguageSerializer> CROSS_LANGUAGE_SERIALIZER_CONFIGURATOR = new InheritableThreadLocalConfigurator<CrossLanguageSerializer>(CrossLanguageSerializer.class, Sys.getEnv()).ifAbsentDefaultService(() -> JsonSerializer.INSTANCE);
    private static final InheritableThreadLocalConfigurator<Serializer> SERIALIZER_CONFIGURATOR = new InheritableThreadLocalConfigurator<Serializer>(Serializer.class, Sys.getEnv()).ifAbsentDefaultService(() -> JavaSerializer.INSTANCE);

    public static <T> T clone(Serializer serializer, T source) {
        if (source == null) {
            return null;
        }
        try {
            byte[] data = serializer.serialize(source);
            return serializer.deserialize(data);
        }
        catch (Exception e) {
            throw new SerializerException("This error is not possible", e);
        }
    }

    public static <T> T clone(T source) {
        return SerializerUtils.clone(SerializerUtils.getSerializer(), source);
    }

    public static CrossLanguageSerializer getCrossLanguageSerializer() {
        return (CrossLanguageSerializer)CROSS_LANGUAGE_SERIALIZER_CONFIGURATOR.get();
    }

    public static InheritableThreadLocalConfigurator<CrossLanguageSerializer> getCrossLanguageSerializerConfigurator() {
        return CROSS_LANGUAGE_SERIALIZER_CONFIGURATOR;
    }

    public static Serializer getSerializer() {
        return (Serializer)SERIALIZER_CONFIGURATOR.get();
    }

    public static InheritableThreadLocalConfigurator<Serializer> getSerializerConfigurator() {
        return SERIALIZER_CONFIGURATOR;
    }

    private SerializerUtils() {
    }
}

