/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.event.ChangeType;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.event.support.StandardBroadcastEventDispatcher;
import io.basc.framework.io.AbstractResource;
import io.basc.framework.io.Resource;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Registration;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class SimpleResourceEventDispatcher
extends StandardBroadcastEventDispatcher<ObservableChangeEvent<Resource>> {
    private static Logger logger = LoggerFactory.getLogger(SimpleResourceEventDispatcher.class);
    static final long LISTENER_PERIOD = (long)Math.max(1, Integer.getInteger("resource.listener.period", 5)) * 1000L;
    static final Timer TIMER = new Timer(SimpleResourceEventDispatcher.class.getSimpleName(), true);
    private volatile AtomicBoolean lock = new AtomicBoolean(false);
    private final AbstractResource resource;
    private final long period;
    private volatile TimerTask timerTask;

    public SimpleResourceEventDispatcher(AbstractResource resource) {
        this(resource, LISTENER_PERIOD);
    }

    public SimpleResourceEventDispatcher(AbstractResource resource, long period) {
        this.resource = resource;
        this.period = Math.max(LISTENER_PERIOD, period);
    }

    protected void listener() {
        if (this.timerTask != null) {
            return;
        }
        this.timerTask = new DefaultEventTimerTask();
        TIMER.schedule(this.timerTask, this.period, this.period);
    }

    protected void cancelListener() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    public AbstractResource getResource() {
        return this.resource;
    }

    @Override
    public void publishEvent(ObservableChangeEvent<Resource> event) {
        if (logger.isDebugEnabled()) {
            logger.debug(event.toString());
        }
        super.publishEvent(event);
    }

    @Override
    public Registration registerListener(EventListener<ObservableChangeEvent<Resource>> eventListener) {
        if (!this.lock.get() && this.lock.compareAndSet(false, true)) {
            this.listener();
        }
        return super.registerListener(eventListener);
    }

    class DefaultEventTimerTask
    extends TimerTask {
        private long last;
        private boolean exist;

        public DefaultEventTimerTask() {
            this.exist = SimpleResourceEventDispatcher.this.resource.exists();
            this.last = this.lastModified();
        }

        protected long lastModified() {
            if (!SimpleResourceEventDispatcher.this.resource.exists()) {
                return -1L;
            }
            try {
                return SimpleResourceEventDispatcher.this.resource.lastModified();
            }
            catch (IOException iOException) {
                return -2L;
            }
        }

        @Override
        public void run() {
            try {
                boolean exist = SimpleResourceEventDispatcher.this.resource.exists();
                long last = this.lastModified();
                if (exist != this.exist) {
                    this.last = last;
                    this.exist = exist;
                    SimpleResourceEventDispatcher.this.publishEvent(new ObservableChangeEvent<Resource>(exist ? ChangeType.CREATE : ChangeType.DELETE, SimpleResourceEventDispatcher.this.resource, SimpleResourceEventDispatcher.this.resource));
                } else if (this.last != last) {
                    this.last = last;
                    SimpleResourceEventDispatcher.this.publishEvent(new ObservableChangeEvent<Resource>(ChangeType.UPDATE, SimpleResourceEventDispatcher.this.resource, SimpleResourceEventDispatcher.this.resource));
                }
            }
            catch (Exception e) {
                logger.error(e, SimpleResourceEventDispatcher.this.resource.toString());
            }
        }
    }
}

