/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.OutputStreamSource;
import io.basc.framework.io.Resource;
import io.basc.framework.lang.NotFoundException;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.Processor;
import java.io.IOException;
import java.io.OutputStream;

public interface WritableResource
extends Resource,
OutputStreamSource {
    default public boolean isWritable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public <T, E extends Throwable> T write(Processor<? super OutputStream, ? extends T, ? extends E> processor) throws IOException, E {
        if (!this.exists()) {
            throw new NotFoundException("not found: " + this.getDescription());
        }
        if (!this.isWritable()) {
            throw new UnsupportedException("not write: " + this.getDescription());
        }
        OutputStream os = null;
        try {
            os = this.getOutputStream();
            T t = processor.process(os);
            return t;
        }
        finally {
            if (os != null && !this.isOpen()) {
                os.close();
            }
        }
    }
}

