/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io.resolver;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.io.IOUtils;
import io.basc.framework.io.Resource;
import io.basc.framework.io.WritableResource;
import io.basc.framework.io.resolver.PropertiesResolver;
import io.basc.framework.lang.NestedRuntimeException;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Properties;

public class DefaultPropertiesResolver
implements PropertiesResolver {
    private static Logger logger = LoggerFactory.getLogger(DefaultPropertiesResolver.class.getName());
    public static final DefaultPropertiesResolver INSTANCE = new DefaultPropertiesResolver();

    @Override
    public boolean canResolveProperties(Resource resource) {
        if (!resource.exists()) {
            return false;
        }
        return resource.getName().endsWith(".properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveProperties(Properties properties, Resource resource, Charset charset) {
        block14: {
            if (!resource.exists()) {
                return;
            }
            InputStream is = null;
            try {
                is = resource.getInputStream();
                if (resource.getName().endsWith(".xml")) {
                    properties.loadFromXML(is);
                    break block14;
                }
                if (charset == null) {
                    properties.load(is);
                    break block14;
                }
                Method method = ReflectionUtils.getDeclaredMethod(Properties.class, "load", Reader.class);
                if (method == null) {
                    logger.warn("The specified character set is only supported in versions of jdk 1.6 and above: " + resource);
                    properties.load(is);
                    break block14;
                }
                InputStreamReader isr = null;
                try {
                    isr = new InputStreamReader(is, charset);
                    ReflectionUtils.invoke(method, properties, isr);
                }
                finally {
                    if (!resource.isOpen()) {
                        IOUtils.close((Closeable)isr);
                    }
                }
            }
            catch (Exception e) {
                throw new NestedRuntimeException(resource.getDescription(), e);
            }
            finally {
                if (!resource.isOpen()) {
                    IOUtils.closeQuietly((Closeable)is);
                }
            }
        }
    }

    @Override
    public void persistenceProperties(Properties properties, WritableResource resource, Charset charset) {
        try {
            resource.produce(output -> {
                if (StringUtils.endsWithIgnoreCase(resource.getName(), ".xml")) {
                    if (charset == null) {
                        properties.storeToXML((OutputStream)output, null);
                    } else {
                        properties.storeToXML((OutputStream)output, null, charset.name());
                    }
                } else if (charset == null) {
                    properties.store((OutputStream)output, null);
                } else {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, charset);){
                        properties.store(writer, null);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new NestedRuntimeException(resource.getDescription(), e);
        }
    }
}

