/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io.support;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TemporaryFile
extends File {
    private static final long serialVersionUID = 1L;
    private static final Set<String> DELETES = Collections.synchronizedSet(new HashSet());

    public TemporaryFile(String path) {
        super(path);
    }

    @Override
    public boolean delete() {
        DELETES.remove(this.getPath());
        return super.delete();
    }

    @Override
    public void deleteOnExit() {
        DELETES.add(this.getPath());
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (String path : DELETES) {
                    new File(path).delete();
                }
            }
        });
    }
}

