/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.lang;

import io.basc.framework.lang.NamedThreadLocal;
import io.basc.framework.util.ObjectUtils;
import java.util.LinkedList;

public class LinkedThreadLocal<E> {
    private final ThreadLocal<LinkedList<E>> local;

    public LinkedThreadLocal(String name) {
        this.local = new NamedThreadLocal<LinkedList<E>>(name);
    }

    public E getCurrent() {
        LinkedList<E> list = this.local.get();
        return list == null ? null : (E)list.getLast();
    }

    public void remove(E element) {
        LinkedList<E> list = this.local.get();
        if (list == null) {
            throw new IllegalStateException("remove nesting element " + element);
        }
        E nesting = list.getLast();
        if (!ObjectUtils.equals(element, nesting)) {
            throw new IllegalStateException("remove nesting [" + nesting + "] conversion service [" + element + "]");
        }
        list.removeLast();
        if (list.isEmpty()) {
            this.local.remove();
        } else {
            this.local.set(list);
        }
    }

    public void set(E element) {
        LinkedList<E> list = this.local.get();
        if (list == null) {
            list = new LinkedList();
            this.local.set(list);
        }
        list.add(element);
    }

    public boolean isCurrent(E element) {
        return ObjectUtils.equals(element, this.getCurrent());
    }

    public boolean exists(E element) {
        LinkedList<E> list = this.local.get();
        if (list == null) {
            return false;
        }
        for (Object e : list) {
            if (!ObjectUtils.equals(element, e)) continue;
            return true;
        }
        return false;
    }
}

