/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.lang;

import java.lang.reflect.InvocationTargetException;

public abstract class NestedExceptionUtils {
    public static String buildMessage(String message, Throwable cause) {
        if (cause == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder(64);
        if (message != null) {
            sb.append(message).append("; ");
        }
        sb.append("nested exception is ").append(cause);
        return sb.toString();
    }

    public static Throwable getRootCause(Throwable original) {
        if (original == null) {
            return null;
        }
        Throwable rootCause = null;
        for (Throwable cause = original.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static Throwable getMostSpecificCause(Throwable original) {
        Throwable rootCause = NestedExceptionUtils.getRootCause(original);
        return rootCause != null ? rootCause : original;
    }

    public static Throwable excludeInvalidNestedExcpetion(Throwable original) {
        Throwable cause = original;
        if (original instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        return cause == null ? original : cause;
    }

    public static String getNonEmptyMessage(Throwable error, boolean localized) {
        Throwable cause;
        String message;
        String string = message = localized ? error.getLocalizedMessage() : error.getMessage();
        while (message == null && (cause = error.getCause()) != null) {
            message = localized ? cause.getLocalizedMessage() : cause.getMessage();
        }
        return message;
    }
}

