/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.locks;

import io.basc.framework.io.FileUtils;
import io.basc.framework.locks.AbstractLock;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.XUtils;
import java.io.File;
import java.io.IOException;

public class FileLock
extends AbstractLock {
    private static Logger logger = LoggerFactory.getLogger(FileLock.class);
    private final File file;
    private final String version;

    public FileLock(File file) {
        this(file, XUtils.getUUID());
    }

    public FileLock(File file, String version) {
        this.file = file;
        this.version = version;
        file.deleteOnExit();
    }

    @Override
    public boolean tryLock() {
        if (this.file.exists()) {
            return false;
        }
        try {
            if (!this.file.createNewFile()) {
                return false;
            }
        }
        catch (IOException e) {
            logger.error(e, "create lock file fail, version {} file {}", this.version, this.file);
            return false;
        }
        try {
            FileUtils.write(this.file, (CharSequence)this.version, "UTF-8");
        }
        catch (IOException e) {
            logger.error(e, "lock fail version {} file {}", this.version, this.file);
            return false;
        }
        return true;
    }

    @Override
    public void unlock() {
        if (this.file.exists()) {
            try {
                String version = FileUtils.readFileToString(this.file, "UTF-8");
                if (this.version.equals(version)) {
                    this.file.delete();
                }
            }
            catch (IOException e) {
                logger.error(e, "unlock fail version {} file {}", this.version, this.file);
            }
        }
    }
}

