/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.locks;

import io.basc.framework.locks.UnableToAcquireLockException;
import io.basc.framework.util.Source;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

@FunctionalInterface
public interface LockFactory {
    public Lock getLock(String var1) throws UnableToAcquireLockException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, E extends Throwable> T process(String name, Source<? extends T, ? extends E> source) throws E, UnableToAcquireLockException {
        Lock lock = this.getLock(name);
        if (lock == null) {
            throw new UnableToAcquireLockException("Lock[" + name + "] is empty");
        }
        if (lock.tryLock()) {
            try {
                T t = source.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        throw new UnableToAcquireLockException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, E extends Throwable> T process(String name, long tryLockTime, TimeUnit tryLockTimeUnit, Source<? extends T, ? extends E> source) throws E, UnableToAcquireLockException, InterruptedException {
        Lock lock = this.getLock(name);
        if (lock == null) {
            throw new UnableToAcquireLockException("Lock[" + name + "] is empty");
        }
        if (lock.tryLock(tryLockTime, tryLockTimeUnit)) {
            try {
                T t = source.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        throw new UnableToAcquireLockException(name);
    }
}

