/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.locks;

import io.basc.framework.locks.LockFactory;
import io.basc.framework.util.CacheableSupplier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public abstract class MemoryLockFactory
implements LockFactory {
    private volatile ConcurrentHashMap<String, Supplier<Lock>> lockMap = new ConcurrentHashMap();

    @Override
    public final Lock getLock(String name) {
        Supplier<Lock> supplier = this.lockMap.get(name);
        if (supplier == null) {
            Supplier<Lock> newSupplier = new LockSupplier(name);
            supplier = this.lockMap.putIfAbsent(name, newSupplier = new CacheableSupplier<Lock>(newSupplier, null));
            if (supplier == null) {
                supplier = newSupplier;
            }
        }
        return supplier.get();
    }

    protected abstract Lock createLock(String var1);

    private final class LockSupplier
    implements Supplier<Lock> {
        private final String name;

        public LockSupplier(String name) {
            this.name = name;
        }

        @Override
        public Lock get() {
            return MemoryLockFactory.this.createLock(this.name);
        }
    }
}

