/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class NoOpLock
implements Lock {
    public static final NoOpLock NO = new NoOpLock(false);
    public static final NoOpLock DEAD = new NoOpLock(true);
    private final boolean lock;

    public NoOpLock(boolean lock) {
        this.lock = lock;
    }

    @Override
    public void lock() {
        if (this.lock) {
            while (true) {
                try {
                    while (true) {
                        this.lockInterruptibly();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        if (this.lock) {
            while (true) {
                Thread.sleep(Long.MAX_VALUE);
            }
        }
    }

    @Override
    public boolean tryLock() {
        return !this.lock;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return !this.lock;
    }

    @Override
    public void unlock() {
        if (this.lock) {
            throw new UnsupportedOperationException("NoOpLock can't unlock");
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("NoOpLock can't provide a condition");
    }
}

