/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.logger;

import io.basc.framework.event.EventListener;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.LevelManager;
import io.basc.framework.logger.Logger;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ObjectUtils;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DynamicLogger
implements Logger,
EventListener<LevelManager> {
    private static final boolean NEED_TO_INFER_CALLER = Boolean.getBoolean("io.basc.framework.logger.need.to.infer.caller");
    private volatile Level level;
    private volatile Logger source;
    private volatile boolean needToInferCaller = NEED_TO_INFER_CALLER;
    private Boolean isNameToClass;

    public DynamicLogger(Logger source) {
        Assert.requiredArgument(source != null, "source");
        this.source = source;
    }

    public boolean isNeedToInferCaller() {
        return this.needToInferCaller;
    }

    public void setNeedToInferCaller(boolean needToInferCaller) {
        this.needToInferCaller = needToInferCaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameToClass() {
        if (this.isNameToClass == null) {
            DynamicLogger dynamicLogger = this;
            synchronized (dynamicLogger) {
                if (this.isNameToClass == null) {
                    this.isNameToClass = ClassUtils.isPresent(this.getName(), null);
                }
            }
        }
        return this.isNameToClass;
    }

    public void setIsNameToClass(boolean isNameToClass) {
        this.isNameToClass = isNameToClass;
    }

    @Nullable
    public StackTraceElement getStackTraceElement() {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement stackTraceElement : stackTraceElements = new Throwable().getStackTrace()) {
            Class<?> sourceClass;
            if (DynamicLogger.class.getName().equals(stackTraceElement.getClassName()) || Logger.class.getName().equals(stackTraceElement.getClassName()) || (sourceClass = ClassUtils.getClass(stackTraceElement.getClassName(), Logger.class.getClassLoader())) != null && Logger.class.isAssignableFrom(sourceClass)) continue;
            return stackTraceElement;
        }
        return null;
    }

    @Override
    public LogRecord createRecord(Level level, Throwable thrown, String msg, Object ... args) {
        LogRecord logRecord = Logger.super.createRecord(level, thrown, msg, args);
        if (this.isNeedToInferCaller()) {
            StackTraceElement stackTraceElement = this.getStackTraceElement();
            if (stackTraceElement != null) {
                logRecord.setSourceClassName(stackTraceElement.getClassName());
                logRecord.setSourceMethodName(stackTraceElement.getMethodName() + "[" + stackTraceElement.getLineNumber() + "]");
            }
        } else if (this.isNameToClass()) {
            logRecord.setSourceClassName(logRecord.getLoggerName());
        }
        return logRecord;
    }

    @Override
    public Level getLevel() {
        Level level = this.level;
        if (level == null) {
            level = this.source.getLevel();
        }
        return level;
    }

    @Override
    public String getName() {
        return this.source.getName();
    }

    public Logger getSource() {
        return this.source;
    }

    @Override
    public void log(LogRecord record) {
        if (this.isLoggable(record.getLevel())) {
            this.source.log(record);
        }
    }

    @Override
    public void onEvent(LevelManager event) {
        Level newLevel;
        Level oldLevel = this.getLevel();
        if (!ObjectUtils.equals(oldLevel, newLevel = event.getLevel(this.getName()))) {
            this.info("Log level changed from {} to {}", oldLevel, newLevel);
            this.setLevel(newLevel);
        }
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
        try {
            this.source.setLevel(level);
        }
        catch (Throwable e) {
            this.error(e, "Exception in setting the source logger log level");
        }
    }

    public void setSource(Logger source) {
        Assert.requiredArgument(source != null, "source");
        Logger oldLogger = this.source;
        this.source = source;
        if (this.level != null) {
            this.source.setLevel(this.level);
        }
        this.info("Logger change from {} to {}", oldLogger, this.source);
    }
}

