/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.logger;

import io.basc.framework.event.support.StandardObservableProperties;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.CustomLevel;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Level;

public class LevelManager
extends StandardObservableProperties<String, Level> {
    private static final Function<Properties, Map<String, Level>> CONVERTER = properties -> {
        HashMap<String, Level> map = new HashMap<String, Level>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Level level;
            Object value;
            Object key = entry.getKey();
            if (key == null || (value = entry.getValue()) == null || (level = CustomLevel.parse(value.toString())) == null) continue;
            map.put(String.valueOf(key), level);
        }
        return map;
    };
    private static final Comparator<String> LEVEL_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            return o1.length() > o2.length() ? -1 : 1;
        }
    };

    public LevelManager() {
        super(new TreeMap(LEVEL_NAME_COMPARATOR), CONVERTER);
    }

    public boolean exists(String name) {
        if (this.containsKey(name)) {
            return true;
        }
        for (String key : this.keySet()) {
            if (!name.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Level getLevel(String name) {
        Level level = (Level)this.get(name);
        if (level != null) {
            return level;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!name.startsWith((String)entry.getKey())) continue;
            return (Level)entry.getValue();
        }
        return null;
    }
}

