/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.logger;

import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.CustomLevel;
import io.basc.framework.util.ObjectUtils;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public interface Logger {
    default public LogRecord createRecord(Level level, Throwable thrown, String msg, Object ... args) {
        LogRecord logRecord = new LogRecord(level, msg);
        if (thrown != null) {
            logRecord.setThrown(thrown);
        }
        if (args != null) {
            logRecord.setParameters(args);
        }
        logRecord.setLoggerName(this.getName());
        return logRecord;
    }

    default public void debug(String msg) {
        this.log(this.createRecord(CustomLevel.DEBUG, null, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void debug(String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.DEBUG, null, msg, args));
    }

    default public void debug(Throwable e, String msg) {
        this.log(this.createRecord(CustomLevel.DEBUG, e, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void debug(Throwable e, String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.DEBUG, e, msg, args));
    }

    default public void error(String msg) {
        this.log(this.createRecord(CustomLevel.ERROR, null, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void error(String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.ERROR, null, msg, args));
    }

    default public void error(Throwable e, String msg) {
        this.log(this.createRecord(CustomLevel.ERROR, e, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void error(Throwable e, String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.ERROR, e, msg, args));
    }

    @Nullable
    default public Level getLevel() {
        return null;
    }

    public String getName();

    default public void info(String msg) {
        this.log(this.createRecord(CustomLevel.INFO, null, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void info(String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.INFO, null, msg, args));
    }

    default public void info(Throwable e, String msg) {
        this.log(this.createRecord(CustomLevel.INFO, e, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void info(Throwable e, String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.INFO, e, msg, args));
    }

    default public boolean isDebugEnabled() {
        return this.isLoggable(CustomLevel.DEBUG);
    }

    default public boolean isErrorEnabled() {
        return this.isLoggable(CustomLevel.ERROR);
    }

    default public boolean isInfoEnabled() {
        return this.isLoggable(CustomLevel.INFO);
    }

    default public boolean isLoggable(Level level) {
        Level acceptLevel = this.getLevel();
        if (acceptLevel == null) {
            return true;
        }
        return CustomLevel.isGreaterOrEqual(level, acceptLevel);
    }

    default public boolean isTraceEnabled() {
        return this.isLoggable(CustomLevel.TRACE);
    }

    default public boolean isWarnEnabled() {
        return this.isLoggable(CustomLevel.WARN);
    }

    default public void log(Level level, String msg) {
        this.log(this.createRecord(level, null, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void log(Level level, String msg, Object ... args) {
        this.log(this.createRecord(level, null, msg, args));
    }

    default public void log(Level level, Throwable e, String msg) {
        this.log(this.createRecord(level, e, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void log(Level level, Throwable e, String msg, Object ... args) {
        this.log(this.createRecord(level, e, msg, args));
    }

    public void log(LogRecord var1);

    default public void setLevel(Level level) {
    }

    default public void trace(String msg) {
        this.log(this.createRecord(CustomLevel.TRACE, null, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void trace(String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.TRACE, null, msg, args));
    }

    default public void trace(Throwable e, String msg) {
        this.log(this.createRecord(CustomLevel.TRACE, e, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void trace(Throwable e, String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.TRACE, e, msg, args));
    }

    default public void warn(String msg) {
        this.log(this.createRecord(CustomLevel.WARN, null, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void warn(String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.WARN, null, msg, args));
    }

    default public void warn(Throwable e, String msg) {
        this.log(this.createRecord(CustomLevel.WARN, e, msg, ObjectUtils.EMPTY_ARRAY));
    }

    default public void warn(Throwable e, String msg, Object ... args) {
        this.log(this.createRecord(CustomLevel.WARN, e, msg, args));
    }
}

