/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.Mapper;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.core.reflect.ReflectionApi;
import io.basc.framework.env.Sys;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.Fields;
import io.basc.framework.value.Value;

public abstract class AbstractMapper<S, T, E extends Throwable>
implements Mapper<S, T, E> {
    private ConversionService conversionService = Sys.getEnv().getConversionService();
    private final TypeDescriptor typeDescriptor;

    public AbstractMapper(TypeDescriptor typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public T convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType) throws E {
        return (T)this.convert(source, sourceType, targetType, null);
    }

    @Override
    public final void transform(S source, TypeDescriptor sourceType, T target, TypeDescriptor targetType) throws E {
        this.transform(source, sourceType, target, targetType, null);
    }

    public Object convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType, Field parentField) throws E {
        if (this.isEntity(targetType.getType())) {
            Object target = ReflectionApi.newInstance(targetType.getType());
            this.transform(source, sourceType, target, targetType, parentField);
            return target;
        }
        return this.getConversionService().convert(source, TypeDescriptor.forObject(source), this.typeDescriptor);
    }

    public void transform(S source, TypeDescriptor sourceType, Object target, TypeDescriptor targetType, Field parentField) throws E {
        for (Field field : (Fields)((Fields)((Fields)Fields.getFields(targetType.getType(), parentField).withSuperclass()).entity()).all()) {
            Object value = this.isEntity(field.getSetter().getType()) ? this.convert(source, sourceType, new TypeDescriptor(field.getSetter()), field) : this.mapField(source, sourceType, field);
            field.getSetter().set(target, value, this.getConversionService());
        }
    }

    protected boolean isEntity(Class<?> type) {
        return !Value.isBaseType(type);
    }

    protected abstract Object mapField(S var1, TypeDescriptor var2, Field var3) throws E;
}

