/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.reflect.ReflectionApi;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.FieldDescriptor;
import io.basc.framework.mapper.FieldFeature;
import io.basc.framework.mapper.Fields;
import io.basc.framework.mapper.Mapping;
import io.basc.framework.mapper.Setter;
import io.basc.framework.util.ClassUtils;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class AbstractMapping
implements Mapping {
    public <T> T newInstance(Class<? extends T> type) {
        return ReflectionApi.newInstance(type);
    }

    @Override
    public <T> T mapping(Class<T> entityClass, Fields fields) {
        T entity = this.newInstance(entityClass);
        for (Field field : fields) {
            Object value = this.isNesting(field.getSetter()) ? this.mapping(field.getSetter().getType(), Fields.getFields(field.getSetter().getType(), field)) : this.getValue(field);
            if (value == null) continue;
            field.getSetter().set(entity, value);
        }
        return entity;
    }

    @Override
    public boolean test(Field field) {
        return FieldFeature.IGNORE_STATIC.test(field);
    }

    protected boolean isNesting(FieldDescriptor fieldDescriptor) {
        Class<?> type = fieldDescriptor.getType();
        return type != String.class && !ClassUtils.isPrimitiveOrWrapper(type);
    }

    protected abstract Object getValue(Field var1);

    protected final String getNestingDisplayName(Field field) {
        if (field.getParent() == null) {
            return field.getSetter().getName();
        }
        LinkedList<Setter> fieldMetadatas = new LinkedList<Setter>();
        for (Field parent = field; parent != null; parent = parent.getParent()) {
            fieldMetadatas.add(parent.getSetter());
        }
        StringBuilder sb = new StringBuilder();
        ListIterator iterator = fieldMetadatas.listIterator(fieldMetadatas.size());
        while (iterator.hasPrevious()) {
            FieldDescriptor fieldMetadata = (FieldDescriptor)iterator.next();
            sb.append(fieldMetadata.getName());
            if (!iterator.hasPrevious()) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

