/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.mapper.AccessibleField;
import io.basc.framework.mapper.DefaultGetter;
import io.basc.framework.mapper.DefaultSetter;
import io.basc.framework.mapper.FieldDescriptor;
import io.basc.framework.mapper.Getter;
import io.basc.framework.mapper.MapperUtils;
import io.basc.framework.mapper.Setter;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.ConcurrentReferenceHashMap;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.XUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class AccessibleFieldFunction
implements Function<Class<?>, Stream<AccessibleField>> {
    private final ConcurrentReferenceHashMap<Class<?>, AccessibleField[]> cacheMap = new ConcurrentReferenceHashMap();
    private final String[] getterMethodPrefixs;
    private final String[] setterMethodPrefixs;

    public AccessibleFieldFunction() {
        this(new String[]{"is", "get"}, new String[]{"set"});
    }

    public AccessibleFieldFunction(String[] getterMethodPrefixs, String[] setterMethodPrefixs) {
        this.getterMethodPrefixs = getterMethodPrefixs == null ? new String[]{} : (String[])getterMethodPrefixs.clone();
        this.setterMethodPrefixs = setterMethodPrefixs == null ? new String[]{} : (String[])setterMethodPrefixs.clone();
    }

    protected Collection<Getter> getGetters(Class<?> currentClass, Field[] fields, Method[] methods) {
        LinkedHashSet<Getter> getters = new LinkedHashSet<Getter>();
        for (Field field : fields) {
            if (ReflectionUtils.isSerialVersionUIDField(field)) continue;
            Method getterMethod = ReflectionUtils.getDeclaredMethod(currentClass, MapperUtils.getGetterMethodName(field), new Class[0]);
            if (getterMethod != null && Modifier.isStatic(getterMethod.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                getterMethod = null;
            }
            DefaultGetter getter = new DefaultGetter(currentClass, field.getName(), field, getterMethod);
            getters.add(getter);
        }
        for (AccessibleObject accessibleObject : methods) {
            if (!ArrayUtils.isEmpty(((Method)accessibleObject).getParameterTypes())) continue;
            for (String methodPrefix : this.getterMethodPrefixs) {
                String name;
                DefaultGetter getter;
                if (!((Method)accessibleObject).getName().startsWith(methodPrefix) || ((Method)accessibleObject).getName().length() <= methodPrefix.length() || getters.contains(getter = new DefaultGetter(currentClass, StringUtils.toLowerCase(name = ((Method)accessibleObject).getName().substring(methodPrefix.length()), 0, 1), null, (Method)accessibleObject))) continue;
                getters.add(getter);
            }
        }
        return getters;
    }

    protected Collection<Setter> getSetters(Class<?> currentClass, Field[] fields, Method[] methods) {
        LinkedHashSet<Setter> setters = new LinkedHashSet<Setter>();
        for (Field field : fields) {
            if (ReflectionUtils.isSerialVersionUIDField(field)) continue;
            Method setterMethod = ReflectionUtils.getDeclaredMethod(currentClass, MapperUtils.getSetterMethodName(field), field.getType());
            if (setterMethod != null && Modifier.isStatic(setterMethod.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                setterMethod = null;
            }
            DefaultSetter setter = new DefaultSetter(currentClass, field.getName(), field, setterMethod);
            setters.add(setter);
        }
        for (AccessibleObject accessibleObject : methods) {
            if (((Method)accessibleObject).getParameterTypes().length != 1) continue;
            for (String methodPrefix : this.setterMethodPrefixs) {
                String name;
                DefaultSetter setter;
                if (!((Method)accessibleObject).getName().startsWith(methodPrefix) || ((Method)accessibleObject).getName().length() <= methodPrefix.length() || setters.contains(setter = new DefaultSetter(currentClass, StringUtils.toLowerCase(name = ((Method)accessibleObject).getName().substring(methodPrefix.length()), 0, 1), null, (Method)accessibleObject))) continue;
                setters.add(setter);
            }
        }
        return setters;
    }

    protected <T extends FieldDescriptor> T metadataFindAndRemove(FieldDescriptor fieldMetadata, Collection<T> metadatas) {
        FieldDescriptor t;
        Iterator<T> iterator = metadatas.iterator();
        while (iterator.hasNext()) {
            t = (FieldDescriptor)iterator.next();
            if (!t.getName().equals(fieldMetadata.getName()) || !t.getType().equals(fieldMetadata.getType())) continue;
            iterator.remove();
            return (T)t;
        }
        iterator = metadatas.iterator();
        while (iterator.hasNext()) {
            t = (FieldDescriptor)iterator.next();
            if (!t.getName().equals(fieldMetadata.getName())) continue;
            iterator.remove();
            return (T)t;
        }
        return null;
    }

    protected List<AccessibleField> toFieldMetadatas(Collection<Getter> getters, Collection<Setter> setters) {
        AccessibleField fieldMetadata;
        LinkedList<AccessibleField> fields = new LinkedList<AccessibleField>();
        for (Getter getter : getters) {
            Setter setter = this.metadataFindAndRemove(getter, setters);
            fieldMetadata = new AccessibleField(getter, setter);
            fields.add(fieldMetadata);
        }
        for (Setter setter : setters) {
            Getter getter = this.metadataFindAndRemove(setter, getters);
            fieldMetadata = new AccessibleField(getter, setter);
            fields.add(fieldMetadata);
        }
        return fields;
    }

    public List<AccessibleField> getFieldMetadataList(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Method[] methods = clazz.getDeclaredMethods();
        Collection<Getter> getters = this.getGetters(clazz, fields, methods);
        Collection<Setter> setters = this.getSetters(clazz, fields, methods);
        return this.toFieldMetadatas(getters, setters);
    }

    @Override
    public Stream<AccessibleField> apply(Class<?> sourceClass) {
        if (sourceClass == null || sourceClass == Object.class) {
            return XUtils.emptyStream();
        }
        AccessibleField[] metadatas = this.cacheMap.get(sourceClass);
        if (metadatas == null) {
            List<AccessibleField> list = this.getFieldMetadataList(sourceClass);
            if (CollectionUtils.isEmpty(list)) {
                return XUtils.emptyStream();
            }
            metadatas = list.toArray(new AccessibleField[0]);
            AccessibleField[] old = this.cacheMap.putIfAbsent(sourceClass, metadatas);
            if (old != null) {
                this.cacheMap.purgeUnreferencedEntries();
                metadatas = old;
            }
        }
        return Arrays.asList(metadatas).stream();
    }
}

