/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.core.ResolvableType;
import io.basc.framework.core.reflect.ReflectionApi;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.lang.NestedExceptionUtils;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.FieldFeature;
import io.basc.framework.mapper.Fields;
import io.basc.framework.mapper.Getter;
import io.basc.framework.mapper.Setter;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public final class Copy
implements Cloneable {
    private boolean invokeCloneableMethod = true;
    private boolean deepCopy = false;
    private boolean nullable = false;
    private boolean ignoreStatic = true;
    public static final Copy SHALLOW = new Copy();
    public static final Copy DEEP = SHALLOW.setDeepCopy(true);

    public Copy clone() {
        return (Copy)((Object)Copy.copy((Object)this, Copy.class));
    }

    public boolean isDeepCopy() {
        return this.deepCopy;
    }

    public Copy setDeepCopy(boolean deepCopy) {
        if (this.deepCopy == deepCopy) {
            return this;
        }
        Copy copy = this.clone();
        copy.deepCopy = deepCopy;
        return copy;
    }

    public boolean isInvokeCloneableMethod() {
        return this.invokeCloneableMethod;
    }

    public Copy setInvokeCloneableMethod(boolean invokeCloneableMethod) {
        if (this.invokeCloneableMethod == invokeCloneableMethod) {
            return this;
        }
        Copy copy = this.clone();
        copy.invokeCloneableMethod = invokeCloneableMethod;
        return copy;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Copy setNullable(boolean nullable) {
        if (this.nullable == nullable) {
            return this;
        }
        Copy copy = new Copy();
        copy.nullable = nullable;
        return copy;
    }

    protected boolean checkModifiers(Getter source, Setter target) {
        int targetModifiers;
        int sourceModifiers = source.getField() == null ? source.getModifiers() : source.getField().getModifiers();
        int n = targetModifiers = target.getField() == null ? target.getModifiers() : target.getField().getModifiers();
        if (this.ignoreStatic && (Modifier.isStatic(sourceModifiers) || Modifier.isStatic(targetModifiers))) {
            return false;
        }
        return !(Modifier.isStatic(sourceModifiers) ^ Modifier.isStatic(targetModifiers));
    }

    protected boolean checkName(Getter source, Setter target) {
        String leftName = source.getField() == null ? source.getName() : source.getField().getName();
        String rightName = target.getField() == null ? target.getName() : target.getField().getName();
        return leftName.equals(rightName);
    }

    protected boolean accept(Getter source, Setter target) {
        return this.checkModifiers(source, target) && this.checkName(source, target);
    }

    protected Object getValue(Getter getter, Object instance) {
        java.lang.reflect.Field field = getter.getField();
        if (field != null) {
            return this.getValue(getter, field, instance);
        }
        return getter.get(instance);
    }

    protected Object getValue(Getter getter, java.lang.reflect.Field field, Object instance) {
        try {
            ReflectionUtils.makeAccessible(field);
            return field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(getter + " instance [" + instance + "]", NestedExceptionUtils.excludeInvalidNestedExcpetion(e));
        }
    }

    protected void setValue(Getter getter, Setter setter, java.lang.reflect.Field field, Object instance, Object value) {
        try {
            ReflectionUtils.makeAccessible(field);
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(setter + " instance [" + instance + "] value [" + value + "]", NestedExceptionUtils.excludeInvalidNestedExcpetion(e));
        }
    }

    protected void setValue(Getter getter, Setter setter, Object instance, Object value) {
        java.lang.reflect.Field field = setter.getField();
        if (field != null) {
            this.setValue(getter, setter, field, instance, value);
            return;
        }
        setter.set(instance, value);
    }

    public void copy(Field sourceField, Object source, Field targetField, Object target) {
        ResolvableType sourceType;
        Getter getter = sourceField.getGetter();
        Setter setter = targetField.getSetter();
        if (getter == null || setter == null) {
            return;
        }
        if (!this.accept(getter, setter)) {
            return;
        }
        ResolvableType targetType = ResolvableType.forType(setter.getField() == null ? setter.getGenericType() : setter.getField().getGenericType());
        if (!targetType.isAssignableFrom(sourceType = ResolvableType.forType(getter.getField() == null ? getter.getGenericType() : getter.getField().getGenericType()))) {
            return;
        }
        Object value = this.getValue(getter, source);
        if (value == null && !this.isNullable()) {
            return;
        }
        if (value != null && this.isDeepCopy()) {
            value = this.clone(new TypeDescriptor(sourceType, null, getter), value, sourceField);
        }
        this.setValue(getter, setter, target, value);
    }

    public <T, S> void copy(Fields sourceFields, S source, Fields targetFields, T target) {
        Assert.requiredArgument(sourceFields != null, "sourceFields");
        Assert.requiredArgument(targetFields != null, "targetFields");
        if (source == null || target == null) {
            return;
        }
        Fields sourceFilterFields = (Fields)((Fields)sourceFields.getters()).shared();
        ((Fields)targetFields.setters()).stream().forEach(targetField -> sourceFilterFields.forEach(sourceField -> this.copy((Field)sourceField, source, (Field)targetField, target)));
    }

    public <T> void copy(Fields fields, T source, T target) {
        Assert.requiredArgument(fields != null, "fields");
        if (source == null || target == null) {
            return;
        }
        ((Fields)fields.strict()).forEach(field -> this.copy((Field)field, source, (Field)field, target));
    }

    public <T> void copy(Class<? extends T> entityClass, Field parentField, T source, T target) {
        Assert.requiredArgument(entityClass != null, "entityClass");
        if (source == null || target == null) {
            return;
        }
        this.copy((Fields)((Fields)((Fields)Fields.getFields(entityClass, parentField).filter((Predicate)FieldFeature.EXISTING_FIELD)).withSuperclass()).all(), source, target);
    }

    public <T, S> void copy(Class<? extends S> sourceClass, S source, @Nullable Field sourceParentField, Class<? extends T> targetClass, T target, @Nullable Field targetParentField) {
        Assert.requiredArgument(sourceClass != null, "sourceClass");
        Assert.requiredArgument(targetClass != null, "targetClass");
        if (source == null || target == null) {
            return;
        }
        if (sourceParentField == null && targetParentField == null && targetClass.isAssignableFrom(sourceClass)) {
            this.copy(targetClass, sourceParentField == targetParentField ? targetParentField : null, source, target);
        } else {
            this.copy((Fields)((Fields)((Fields)Fields.getFields(sourceClass, sourceParentField).filter((Predicate)FieldFeature.EXISTING_GETTER_FIELD)).withSuperclass()).all(), source, (Fields)((Fields)((Fields)Fields.getFields(targetClass, targetParentField).filter((Predicate)FieldFeature.EXISTING_SETTER_FIELD)).withSuperclass()).all(), target);
        }
    }

    public <T, S> T copy(TypeDescriptor sourceType, S source, @Nullable Field sourceParentField, TypeDescriptor targetType, @Nullable Field targetParentField) {
        Assert.requiredArgument(sourceType != null, "sourceType");
        Assert.requiredArgument(targetType != null, "targetType");
        if (source == null) {
            return null;
        }
        if (targetType.isArray() && sourceType.isArray() && targetType.isAssignableTo(sourceType)) {
            return this.cloneArray(source, sourceParentField, sourceType);
        }
        if (targetType.isCollection() && sourceType.isCollection() && targetType.isAssignableTo(sourceType)) {
            return this.cloneCollection((Collection)source, sourceParentField, targetType);
        }
        if (targetType.isMap() && sourceType.isMap() && targetType.isAssignableTo(sourceType)) {
            return this.cloneMap((Map)source, sourceParentField, targetType);
        }
        Class<?> targetClass = targetType.getType();
        if (!ReflectionApi.isInstance(targetClass)) {
            if (targetClass.isInstance(source)) {
                return (T)targetClass.cast(source);
            }
            throw new IllegalStateException("Unable to copy " + sourceType + " -> " + targetType);
        }
        Object target = ReflectionApi.newInstance(targetClass);
        this.copy(sourceType.getType(), source, sourceParentField, targetClass, target, targetParentField);
        return (T)target;
    }

    private <T> T cloneArray(Object sourceArray, Field sourceParentField, TypeDescriptor targetType) {
        int size = Array.getLength(sourceArray);
        TypeDescriptor elementType = targetType.getElementTypeDescriptor();
        Object newArr = Array.newInstance(elementType.getType(), size);
        for (int i = 0; i < size; ++i) {
            Array.set(newArr, i, this.clone(elementType, Array.get(sourceArray, i), sourceParentField));
        }
        return (T)newArr;
    }

    private <T> T cloneCollection(Collection<?> sources, Field sourceParentField, TypeDescriptor targetType) {
        Collection<?> targets;
        TypeDescriptor elementType = targetType.getElementTypeDescriptor();
        try {
            targets = CollectionFactory.createCollection(targetType.getType(), elementType.getType(), sources.size());
        }
        catch (IllegalArgumentException e) {
            Object value = ReflectionUtils.invokeCloneMethod(sources);
            return (T)(value == null ? sources : value);
        }
        for (Object source : sources) {
            targets.add(this.clone(elementType, source, sourceParentField));
        }
        return (T)targets;
    }

    private <T> T cloneMap(Map<?, ?> sourceMap, Field sourceParentField, TypeDescriptor targetType) {
        Map<?, ?> targetMap;
        TypeDescriptor keyType = targetType.getMapKeyTypeDescriptor();
        TypeDescriptor valueType = targetType.getMapValueTypeDescriptor();
        try {
            targetMap = CollectionFactory.createMap(keyType.getType(), valueType.getType(), sourceMap.size());
        }
        catch (IllegalArgumentException e) {
            Object value = ReflectionUtils.invokeCloneMethod(sourceMap);
            return (T)(value == null ? sourceMap : value);
        }
        for (Map.Entry<?, ?> entry : sourceMap.entrySet()) {
            targetMap.put(this.clone(keyType, entry.getKey(), sourceParentField), this.clone(valueType, entry.getValue(), sourceParentField));
        }
        return (T)targetMap;
    }

    public <T> T clone(T source, @Nullable Field parentField) {
        if (source == null) {
            return null;
        }
        return this.clone(TypeDescriptor.forObject(source), source, parentField);
    }

    public <T> T clone(TypeDescriptor sourceType, T source, @Nullable Field parentField) {
        Object value;
        Assert.requiredArgument(sourceType != null, "sourceType");
        if (source == null) {
            return null;
        }
        if (sourceType.isPrimitive() || sourceType.isEnum()) {
            return source;
        }
        if (sourceType.isArray()) {
            return this.cloneArray(source, parentField, sourceType);
        }
        if (sourceType.isCollection()) {
            return this.cloneCollection((Collection)source, parentField, sourceType);
        }
        if (sourceType.isMap()) {
            return this.cloneMap((Map)source, parentField, sourceType);
        }
        if (this.isInvokeCloneableMethod() && (value = ReflectionUtils.invokeCloneMethod(source)) != null) {
            return value;
        }
        Class<?> sourceClass = sourceType.getType();
        if (!ReflectionApi.isInstance(sourceClass)) {
            return source;
        }
        Object target = ReflectionApi.newInstance(sourceClass);
        this.copy(sourceClass, parentField, source, target);
        return (T)target;
    }

    public static <T> T clone(T source) {
        return DEEP.clone(source, null);
    }

    public static <T> T copy(Object source, Class<? extends T> targetClass) {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(targetClass != null, "targetClass");
        return SHALLOW.copy(TypeDescriptor.forObject(source), source, null, TypeDescriptor.valueOf(targetClass), null);
    }

    public static <T> T copy(Object source, T target) {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(target != null, "target");
        SHALLOW.copy(source.getClass(), source, null, target.getClass(), target, null);
        return target;
    }

    public static <T> T cloneAndSetValue(Class<? extends T> sourceClass, Object source, java.lang.reflect.Field field, Object value) {
        Class<? extends T> target = Copy.copy(source, sourceClass);
        ReflectionUtils.set(field, target, value);
        return (T)target;
    }
}

