/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.ConversionFactory;
import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.ConversionServiceAware;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.core.ResolvableType;
import io.basc.framework.lang.NamedThreadLocal;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.AnyMapAccess;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.FieldDescriptor;
import io.basc.framework.mapper.ObjectAccess;
import io.basc.framework.mapper.ObjectAccessFactory;
import io.basc.framework.mapper.ObjectMapper;
import io.basc.framework.mapper.ObjectMapperContext;
import io.basc.framework.mapper.Parameter;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.mapper.PropertyFactoryAccess;
import io.basc.framework.mapper.Structure;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.Processor;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.XUtils;
import io.basc.framework.util.comparator.TypeComparator;
import io.basc.framework.value.PropertyFactory;
import io.basc.framework.value.Value;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultObjectMapper<S, E extends Throwable>
extends ConversionFactory<S, E>
implements ObjectMapper<S, E>,
ConversionServiceAware {
    private static final ThreadLocal<Integer> ENTITY_NESTING_DEPTH = new NamedThreadLocal<Integer>(DefaultObjectMapper.class.getName() + "#ENTITY_NESTING_DEPTH"){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final ObjectMapperContext context = new ObjectMapperContext();
    private final Map<Class<?>, ObjectAccessFactory<?, ? extends E>> objectAccessFactoryMap = new TreeMap(TypeComparator.DEFAULT);
    private final Map<Class<?>, Structure<? extends Field>> structureMap = new ConcurrentHashMap();

    public DefaultObjectMapper() {
        this.registerObjectAccessFactory((Class<T>)PropertyFactory.class, (s, e) -> new PropertyFactoryAccess((PropertyFactory)s));
        this.registerObjectAccessFactory((Class<T>)Map.class, (s, e) -> new AnyMapAccess((Map)s, e, this.getConversionService()));
    }

    protected boolean accept(Field sourceField, FieldDescriptor fieldDescriptor, ObjectMapperContext context) {
        Collection<String> names;
        if (context.getFilter() != null && !context.getFilter().test(sourceField)) {
            return false;
        }
        if (!context.getIgnoreAnnotationNameMatcher().isEmpty()) {
            for (Annotation annotation : fieldDescriptor.getAnnotations()) {
                if (!context.getIgnoreAnnotationNameMatcher().get(annotation.annotationType().getName()).orElse(false).booleanValue()) continue;
                return false;
            }
        }
        if ((StringUtils.isNotEmpty(context.getNamePrefix()) || !context.getIgnoreNameMatcher().isEmpty()) && (names = sourceField.getNames(context)) != null) {
            boolean accept = false;
            for (String name : names) {
                if (!name.startsWith(context.getNamePrefix()) || context.getIgnoreNameMatcher().get(name).orElse(false).booleanValue()) continue;
                accept = true;
                break;
            }
            if (!accept) {
                return false;
            }
        }
        return true;
    }

    protected void appendMapProperty(Map<String, Object> valueMap, String prefix, ObjectAccess<E> objectAccess, ObjectMapperContext context) throws E {
        Enumeration<String> keys = objectAccess.keys();
        while (keys.hasMoreElements()) {
            Parameter value;
            String key = keys.nextElement();
            if (StringUtils.isNotEmpty(prefix) && (key.equals(prefix) || valueMap.containsKey(key)) || !key.startsWith(prefix) || (value = objectAccess.get(key)) == null || context.isIgnoreNull() && !value.isPresent()) continue;
            valueMap.put(StringUtils.isEmpty(prefix) ? key : key.substring(prefix.length() + (prefix.endsWith(context.getNameConnector()) ? 0 : context.getNameConnector().length())), value.get());
        }
    }

    public <R> R convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType, Field parentField, ObjectMapperContext context) throws E {
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.transform(source, sourceType, target, targetType, parentField, context);
        return (R)target;
    }

    public <R> R convert(ObjectAccess<E> sourceAccess, TypeDescriptor targetType, Field parentField, ObjectMapperContext context) throws E {
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.transform(sourceAccess, target, targetType, parentField, context);
        return (R)target;
    }

    public <R> R convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType, @Nullable Field parentField) throws E {
        return this.convert(source, sourceType, targetType, parentField, this.getContext(targetType, this.context));
    }

    @Override
    public Object convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        return this.convert(source, sourceType, targetType, targetStructure, this.getContext(targetType, this.context));
    }

    public <R> R convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType, Structure<? extends Field> targetStructure, ObjectMapperContext context) throws E {
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.transform(source, sourceType, target, targetType, targetStructure, context);
        return (R)target;
    }

    @Override
    public <T> void copy(T source, TypeDescriptor sourceType, T target, TypeDescriptor targetType, Iterator<? extends Field> properties) throws E {
        this.copy(source, sourceType, target, targetType, properties, this.getContext(targetType, this.context));
    }

    public <T> void copy(T source, TypeDescriptor sourceType, T target, TypeDescriptor targetType, Iterator<? extends Field> properties, ObjectMapperContext context) throws E {
        while (properties.hasNext()) {
            Parameter value;
            Field field = properties.next();
            if (!field.isSupportGetter() || !field.isSupportSetter() || !this.accept(field, field.getSetter(), context) || (value = field.getParameter(source)) == null || !value.isPresent()) continue;
            field.set(target, value);
        }
    }

    @Override
    public <T> void copy(T source, TypeDescriptor sourceType, T target, TypeDescriptor targetType, Structure<? extends Field> structure) throws E {
        this.copy(source, sourceType, target, targetType, structure, this.getContext(targetType, this.context));
    }

    public <T> void copy(T source, TypeDescriptor sourceType, T target, TypeDescriptor targetType, Structure<? extends Field> structure, ObjectMapperContext context) throws E {
        Iterator iterator = structure.pages().iterator();
        while (iterator.hasNext()) {
            Structure useStructure = (Structure)iterator.next();
            this.copy(source, sourceType, target, targetType, useStructure.iterator(), context);
        }
    }

    public final ObjectMapperContext getContext() {
        return this.context;
    }

    public ObjectMapperContext getContext(TypeDescriptor targetType, ObjectMapperContext parent) {
        return parent;
    }

    public final ConversionService getConversionService() {
        return this.context.getConversionService();
    }

    @Override
    public <T> ObjectAccessFactory<T, E> getObjectAccessFactory(Class<? extends T> type) {
        ObjectAccessFactory<?, ? extends E> object = this.objectAccessFactoryMap.get(type);
        if (object == null) {
            for (Map.Entry<Class<?>, ObjectAccessFactory<?, E>> entry : this.objectAccessFactoryMap.entrySet()) {
                if (!ClassUtils.isAssignable(entry.getKey(), type)) continue;
                object = entry.getValue();
                break;
            }
        }
        return object;
    }

    @Override
    public Structure<? extends Field> getStructure(Class<?> entityClass) {
        Structure<? extends Field> structure = this.structureMap.get(entityClass);
        if (structure == null) {
            structure = ObjectMapper.super.getStructure(entityClass);
        }
        return structure;
    }

    private Processor<Field, Parameter, E> getValueProcessor(ObjectMapperContext context, ObjectAccess<E> objectAccess) throws E {
        return p -> {
            Collection<String> names = p.getNames(context);
            if (context.getLogger().isTraceEnabled()) {
                context.getLogger().trace(p.getName() + " - " + names);
            }
            for (String string : names) {
                Parameter value = objectAccess.get(string);
                if (value == null || !value.isPresent()) continue;
                return value;
            }
            if (Map.class.isAssignableFrom(p.getSetter().getType())) {
                LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
                for (String name : names) {
                    this.appendMapProperty(valueMap, name + context.getNameConnector(), objectAccess, context);
                }
                if (!CollectionUtils.isEmpty(valueMap)) {
                    Value value = Value.of(valueMap, TypeDescriptor.map(LinkedHashMap.class, String.class, Object.class));
                    return new Parameter(context.getNamePrefix() == null ? p.getName() : context.getNamePrefix() + p.getName(), (Object)value);
                }
            }
            return null;
        };
    }

    @Override
    public <R extends S> R invert(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, TypeDescriptor targetType) throws E {
        return this.invert(source, sourceType, sourceStructure, targetType, this.getContext(targetType, this.context));
    }

    public <R extends S> R invert(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, TypeDescriptor targetType, ObjectMapperContext context) throws E {
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.transform(source, sourceType, sourceStructure, target, targetType, context);
        return (R)target;
    }

    protected boolean isEntity(TypeDescriptor sourceType, Field field, ParameterDescriptor parameter, ObjectMapperContext context) {
        return this.isEntity(parameter.getType()) || context.getEntityTypeMatcher().get(parameter.getType().getName()).orElse(false) != false;
    }

    @Override
    public boolean isStructureRegistred(Class<?> entityClass) {
        return this.structureMap.containsKey(entityClass);
    }

    @Override
    public <T> void registerObjectAccessFactory(Class<T> type, ObjectAccessFactory<? super T, ? extends E> factory) {
        Assert.requiredArgument(type != null, "type");
        if (factory == null) {
            this.objectAccessFactoryMap.remove(type);
        } else {
            this.objectAccessFactoryMap.put(type, factory);
        }
    }

    @Override
    public void registerStructure(Class<?> entityClass, Structure<? extends Field> structure) {
        Assert.requiredArgument(entityClass != null, "entityClass");
        if (structure == null) {
            this.structureMap.remove(entityClass);
        } else {
            this.structureMap.put(entityClass, structure);
        }
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.context.setConversionService(conversionService);
    }

    @Override
    public void transform(Object source, TypeDescriptor sourceType, Iterator<? extends Field> sourceProperties, Object target, TypeDescriptor targetType, Iterator<? extends Field> targetProperties) throws E {
        this.transform(source, sourceType, sourceProperties, target, targetType, targetProperties, this.getContext(targetType, this.context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Object source, TypeDescriptor sourceType, Iterator<? extends Field> sourceProperties, Object target, TypeDescriptor targetType, Iterator<? extends Field> targetProperties, ObjectMapperContext context) throws E {
        Comparator comparator = (left, right) -> {
            if (left.getDeclaringClass() == right.getDeclaringClass()) {
                if (left.getType() == right.getType()) {
                    return 0;
                }
                return right.getType().isAssignableFrom(left.getType()) ? 1 : -1;
            }
            return right.getDeclaringClass().isAssignableFrom(left.getDeclaringClass()) ? 1 : -1;
        };
        try {
            List targetFields = XUtils.stream(targetProperties).filter(e -> e.isSupportSetter() && this.accept((Field)e, e.getSetter(), context)).sorted((left, right) -> comparator.compare(left.getGetter(), right.getGetter())).collect(Collectors.toList());
            List sourceFields = XUtils.stream(sourceProperties).filter(e -> e.isSupportGetter() && this.accept((Field)e, e.getGetter(), context)).sorted((left, right) -> comparator.compare(left.getSetter(), right.getSetter())).collect(Collectors.toList());
            block3: for (Field sourceField : sourceFields) {
                if (targetFields.isEmpty()) {
                    break;
                }
                Iterator iterator = targetFields.iterator();
                while (iterator.hasNext()) {
                    Value value;
                    Field targetField = (Field)iterator.next();
                    if (!sourceField.test(targetField) || !this.accept(sourceField, targetField.getSetter(), context)) continue;
                    if ((context.getEntityNestingMaxiumDepth() < 0 || ENTITY_NESTING_DEPTH.get() < context.getEntityNestingMaxiumDepth()) && this.isEntity(targetType, targetField, targetField.getSetter(), context)) {
                        ENTITY_NESTING_DEPTH.set(ENTITY_NESTING_DEPTH.get() + 1);
                        TypeDescriptor entityType = new TypeDescriptor(targetField.getSetter());
                        ObjectMapperContext contextUse = this.getContext(entityType, context);
                        Object entity = this.convert(source, sourceType, entityType, targetField, contextUse);
                        value = Value.of(entity, entityType, context.getConversionService());
                    } else {
                        Parameter parameter = sourceField.getParameter(source);
                        if (parameter != null) {
                            parameter.setConverter(context.getConversionService());
                        }
                        value = parameter;
                    }
                    if (value == null || context.isIgnoreNull() && !value.isPresent()) continue block3;
                    targetField.set(target, value);
                    iterator.remove();
                    continue block3;
                }
            }
        }
        finally {
            ENTITY_NESTING_DEPTH.remove();
        }
    }

    @Override
    public void transform(Object source, TypeDescriptor sourceType, Iterator<? extends Field> sourceProperties, ObjectAccess<? extends E> targetAccess) throws E {
        this.transform(source, sourceType, sourceProperties, targetAccess, this.context);
    }

    public void transform(Object source, TypeDescriptor sourceType, Iterator<? extends Field> sourceProperties, ObjectAccess<? extends E> targetAccess, ObjectMapperContext context) throws E {
        while (sourceProperties.hasNext()) {
            Parameter parameter;
            Field field = sourceProperties.next();
            if (!field.isSupportGetter() || !this.accept(field, field.getGetter(), context) || (parameter = field.getParameter(source)) == null || context.isIgnoreNull() && !parameter.isPresent()) continue;
            targetAccess.set(parameter);
        }
    }

    public void transform(Object source, TypeDescriptor sourceType, Object target, TypeDescriptor targetType, Field parentField, ObjectMapperContext context) throws E {
        if (this.isObjectAccessFactoryRegistred(sourceType.getType())) {
            this.transform(this.getObjectAccess(source, sourceType), target, targetType, context);
            return;
        }
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(source, sourceType, this.getObjectAccess(target, targetType), context);
            return;
        }
        Structure<Field> targetStructure = this.getStructure(targetType.getType());
        if (parentField != null) {
            targetStructure = targetStructure.setParentField(parentField);
        }
        if (targetType.getType() == sourceType.getType() || sourceType.getType().isAssignableFrom(targetType.getType())) {
            this.copy(source, sourceType, target, targetType, targetStructure, context);
            return;
        }
        this.transform(source, sourceType, this.getStructure(sourceType.getType()), target, targetType, targetStructure, context);
    }

    @Override
    public void transform(Object source, TypeDescriptor sourceType, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        this.transform(source, sourceType, target, targetType, targetStructure);
    }

    public void transform(Object source, TypeDescriptor sourceType, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure, ObjectMapperContext context) throws E {
        if (this.isObjectAccessFactoryRegistred(sourceType.getType())) {
            this.transform(this.getObjectAccess(source, sourceType), target, targetType, targetStructure, context);
        } else {
            this.transform(source, sourceType, this.getStructure(sourceType.getType()), target, targetType, targetStructure, context);
        }
    }

    @Override
    public void transform(Object source, TypeDescriptor sourceType, ObjectAccess<? extends E> targetAccess) throws E {
        this.transform(source, sourceType, targetAccess, this.context);
    }

    public void transform(Object source, TypeDescriptor sourceType, ObjectAccess<? extends E> targetAccess, ObjectMapperContext context) throws E {
        if (source == null) {
            return;
        }
        if (this.isObjectAccessFactoryRegistred(sourceType.getType())) {
            this.transform(this.getObjectAccess(source, sourceType), targetAccess, context);
            return;
        }
        Structure<Field> sourceStructure = this.getStructure(sourceType.getType());
        this.transform(source, sourceType, sourceStructure, targetAccess, context);
    }

    @Override
    public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, Object target, TypeDescriptor targetType) throws E {
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(source, sourceType, sourceStructure, this.getObjectAccess(target, targetType));
        } else {
            this.transform(source, sourceType, sourceStructure, target, targetType, this.getStructure(targetType.getType()));
        }
    }

    public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, Object target, TypeDescriptor targetType, ObjectMapperContext context) throws E {
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(source, sourceType, sourceStructure, this.getObjectAccess(target, targetType), context);
        } else {
            this.transform(source, sourceType, sourceStructure, target, targetType, this.getStructure(targetType.getType()), context);
        }
    }

    @Override
    public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        this.transform(source, sourceType, sourceStructure, target, targetType, targetStructure, this.getContext(targetType, this.context));
    }

    public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure, ObjectMapperContext context) throws E {
        this.transform(source, sourceType, ((Structure)sourceStructure.all()).stream().iterator(), target, targetType, ((Structure)targetStructure.all()).stream().iterator(), context);
    }

    @Override
    public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, ObjectAccess<? extends E> targetAccess) throws E {
        this.transform(source, sourceType, sourceStructure, targetAccess, this.context);
    }

    public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, ObjectAccess<? extends E> targetAccess, ObjectMapperContext context) throws E {
        Iterator iterator = sourceStructure.pages().iterator();
        while (iterator.hasNext()) {
            Structure structure = (Structure)iterator.next();
            this.transform(source, sourceType, structure.iterator(), targetAccess, context);
        }
    }

    @Override
    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType) throws E {
        this.transform(sourceAccess, target, targetType, this.getContext(targetType, this.context));
    }

    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Field parentField, ObjectMapperContext context) throws E {
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(sourceAccess, this.getObjectAccess(target, targetType), context);
        } else {
            Structure<Field> targetStructure = this.getStructure(targetType.getType());
            if (parentField != null) {
                targetStructure = targetStructure.setParentField(parentField);
            }
            this.transform(sourceAccess, target, targetType, targetStructure, context);
        }
    }

    @Override
    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Iterator<? extends Field> targetProperties) throws E {
        this.transform(sourceAccess, target, targetType, targetProperties, this.getContext(targetType, this.context));
    }

    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Iterator<? extends Field> targetProperties, ObjectMapperContext context) throws E {
        this.transform(sourceAccess, target, targetType, targetProperties, context, this.getValueProcessor(context, sourceAccess));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Iterator<? extends Field> targetProperties, ObjectMapperContext context, Processor<Field, Parameter, E> valueProcessor) throws E {
        try {
            while (targetProperties.hasNext()) {
                Parameter parameter;
                Field field = targetProperties.next();
                if (!field.isSupportSetter() || !this.accept(field, field.getSetter(), context)) continue;
                if ((context.getEntityNestingMaxiumDepth() < 0 || ENTITY_NESTING_DEPTH.get() < context.getEntityNestingMaxiumDepth()) && this.isEntity(targetType, field, field.getSetter(), context)) {
                    ENTITY_NESTING_DEPTH.set(ENTITY_NESTING_DEPTH.get() + 1);
                    TypeDescriptor entityType = new TypeDescriptor(field.getSetter());
                    ObjectMapperContext contextToUse = this.getContext(targetType, context);
                    Object entity = this.convert(sourceAccess, entityType, field, contextToUse);
                    parameter = new Parameter(field.getName(), entity, entityType);
                } else {
                    parameter = valueProcessor.process(field);
                }
                if (parameter == null || context.isIgnoreNull() && !parameter.isPresent()) continue;
                parameter.setConverter(context.getConversionService());
                field.set(target, parameter);
            }
        }
        finally {
            ENTITY_NESTING_DEPTH.remove();
        }
    }

    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, ObjectMapperContext context) throws E {
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(sourceAccess, this.getObjectAccess(target, targetType), context);
            return;
        }
        Structure<Field> targetStructure = this.getStructure(targetType.getType());
        this.transform(sourceAccess, target, targetType, targetStructure, context);
    }

    @Override
    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        this.transform(sourceAccess, target, targetType, targetStructure, this.getContext(targetType, this.context));
    }

    public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure, ObjectMapperContext context) throws E {
        Iterator iterator = targetStructure.pages().iterator();
        ObjectMapperContext useContext = context;
        while (iterator.hasNext()) {
            Structure structure = (Structure)iterator.next();
            useContext = this.getContext(targetType.convert(ResolvableType.forClass(structure.getSourceClass())), useContext);
            this.transform(sourceAccess, target, targetType, structure.iterator(), useContext);
        }
    }

    @Override
    public void transform(ObjectAccess<E> sourceAccess, ObjectAccess<? extends E> targetAccess) throws E {
        this.transform(sourceAccess, targetAccess, this.context);
    }

    @Override
    public void transform(ObjectAccess<E> sourceAccess, ObjectAccess<? extends E> targetAccess, ObjectMapperContext context) throws E {
        sourceAccess.copyByPrefix(targetAccess, context.getNamePrefix());
    }
}

