/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.annotation.AnnotatedElementUtils;
import io.basc.framework.core.annotation.AnnotatedElementWrapper;
import io.basc.framework.core.annotation.AnnotatedElements;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.util.ObjectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.HashMap;

public class DefaultParameterDescriptor
extends AnnotatedElementWrapper<AnnotatedElement>
implements ParameterDescriptor {
    private final String name;
    private final Class<?> type;
    private final Type genericType;

    public DefaultParameterDescriptor(String name, Class<?> type) {
        this(name, type, type);
    }

    public DefaultParameterDescriptor(String name, Class<?> type, @Nullable Type genericType) {
        this(name, AnnotatedElements.EMPTY, type, genericType);
    }

    public DefaultParameterDescriptor(String name, Annotation[] annotations, Class<?> type, @Nullable Type genericType) {
        this(name, AnnotatedElementUtils.forAnnotations(annotations), type, genericType);
    }

    public DefaultParameterDescriptor(String name, AnnotatedElement annotatedElement, Class<?> type, @Nullable Type genericType) {
        super(annotatedElement);
        this.name = name;
        this.type = type;
        this.genericType = genericType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType == null ? this.type : this.genericType;
    }

    @Override
    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>(4, 1.0f);
        map.put("name", this.name);
        map.put("type", this.type);
        map.put("genericType", this.genericType);
        return ((Object)map).toString();
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        if (this.name != null) {
            code += this.name.hashCode();
        }
        if (this.type != null) {
            code += this.type.hashCode();
        }
        if (this.genericType != null) {
            code += this.genericType.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultParameterDescriptor) {
            return super.equals(obj) && ObjectUtils.equals(this.name, ((DefaultParameterDescriptor)obj).name) && ObjectUtils.equals(this.type, ((DefaultParameterDescriptor)obj).type) && ObjectUtils.equals(this.genericType, ((DefaultParameterDescriptor)obj).genericType);
        }
        return false;
    }
}

