/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.ParameterNameDiscoverer;
import io.basc.framework.core.annotation.Order;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.mapper.ExecutableParameterDescriptors;
import io.basc.framework.mapper.ParameterDescriptors;
import io.basc.framework.mapper.ParameterUtils;
import io.basc.framework.util.comparator.CompareUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class ExecutableParameterDescriptorsIterator
implements Iterator<ParameterDescriptors> {
    private static final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            Deprecated d1 = o1.getAnnotation(Deprecated.class);
            Deprecated d2 = o2.getAnnotation(Deprecated.class);
            int v1 = o1.getModifiers();
            int v2 = o2.getModifiers();
            if (d1 == null || d2 == null) {
                if (d1 != null) {
                    v1 = Integer.MAX_VALUE;
                }
                if (d2 != null) {
                    v2 = Integer.MAX_VALUE;
                }
            }
            if (v1 == v2) {
                return CompareUtils.compare(o1.getParameterTypes().length, o2.getParameterTypes().length, true);
            }
            return CompareUtils.compare(v1, v2, false);
        }
    };
    private static final Comparator<Method> METHOD_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            Deprecated d1 = o1.getAnnotation(Deprecated.class);
            Deprecated d2 = o2.getAnnotation(Deprecated.class);
            int v1 = o1.getModifiers();
            int v2 = o2.getModifiers();
            if (d1 == null || d2 == null) {
                if (d1 != null) {
                    v1 = Integer.MAX_VALUE;
                }
                if (d2 != null) {
                    v2 = Integer.MAX_VALUE;
                }
            }
            if (v1 == v2) {
                return CompareUtils.compare(o1.getParameterTypes().length, o2.getParameterTypes().length, true);
            }
            return CompareUtils.compare(v1, v2, false);
        }
    };
    private final Iterator<? extends Executable> iterator;
    private final Class<?> targetClass;
    private final ParameterNameDiscoverer parameterNameDiscoverer;

    public static <E extends AnnotatedElement> int compare(E o1, E o2, Comparator<E> comparator) {
        Order auto1 = o1.getAnnotation(Order.class);
        Order auto2 = o2.getAnnotation(Order.class);
        if (auto1 != null && auto2 != null) {
            if (auto1.value() == auto2.value()) {
                return comparator.compare(o1, o2);
            }
            return CompareUtils.compare(auto1.value(), auto2.value(), true);
        }
        if (auto1 == null && auto2 == null) {
            return comparator.compare(o1, o2);
        }
        return auto1 != null ? 1 : 0;
    }

    public ExecutableParameterDescriptorsIterator(ParameterNameDiscoverer parameterNameDiscoverer, Class<?> targetClass, Iterator<? extends Executable> iterator) {
        this.iterator = iterator;
        this.targetClass = targetClass;
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public ExecutableParameterDescriptorsIterator(Class<?> clazz) {
        this(ParameterUtils.getParameterNameDiscoverer(), clazz, ReflectionUtils.getDeclaredConstructors(clazz).stream().sorted((o1, o2) -> ExecutableParameterDescriptorsIterator.compare(o1, o2, CONSTRUCTOR_COMPARATOR)).iterator());
    }

    public ExecutableParameterDescriptorsIterator(Class<?> targetClass, Method method, boolean polymorphic) {
        this(ParameterUtils.getParameterNameDiscoverer(), targetClass, polymorphic ? ReflectionUtils.getDeclaredMethods(targetClass).stream().sorted((o1, o2) -> ExecutableParameterDescriptorsIterator.compare(o1, o2, METHOD_COMPARATOR)).iterator() : Arrays.asList(method).iterator());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ParameterDescriptors next() {
        Executable executable = this.iterator.next();
        return new ExecutableParameterDescriptors(this.parameterNameDiscoverer, this.targetClass, executable);
    }
}

