/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.core.ResolvableType;
import io.basc.framework.core.reflect.ReflectionApi;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.AccessibleField;
import io.basc.framework.mapper.DefaultGetter;
import io.basc.framework.mapper.DefaultSetter;
import io.basc.framework.mapper.Getter;
import io.basc.framework.mapper.ObjectMapperContext;
import io.basc.framework.mapper.Parameter;
import io.basc.framework.mapper.Setter;
import io.basc.framework.mapper.Structure;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ParentDiscover;
import io.basc.framework.util.Processor;
import io.basc.framework.util.ReversibleIterator;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.alias.AliasRegistry;
import io.basc.framework.value.Value;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.function.Predicate;

public class Field
extends AccessibleField
implements Member,
ParentDiscover<Field>,
Predicate<Field> {
    protected Field parent;
    protected Class<?> declaringClass;
    protected Collection<String> aliasNames;
    protected Integer modifiers;
    protected Boolean synthetic;
    protected String name;
    protected int nameNestingDepth = -1;
    protected String nameNestingConnector = "_";

    public Field() {
    }

    public Field(Field parent, Class<?> declaringClass, String name, java.lang.reflect.Field field, Method getter, Method setter) {
        this(parent, declaringClass, (Getter)(field == null && getter == null ? null : new DefaultGetter(declaringClass, name, field, getter)), (Setter)(field == null && setter == null ? null : new DefaultSetter(declaringClass, name, field, setter)));
    }

    public Field(Field parent, Class<?> declaringClass, Getter getter, Setter setter) {
        super(getter, setter);
        this.declaringClass = declaringClass;
        this.parent = parent;
    }

    public Field(Field parent, Class<?> declaringClass, AccessibleField metadata) {
        super(metadata);
        this.parent = parent;
        this.declaringClass = declaringClass;
    }

    public Field(Field field) {
        super(field);
        if (field != null) {
            this.parent = field.parent;
            this.declaringClass = field.declaringClass;
            this.aliasNames = field.aliasNames;
            this.modifiers = field.modifiers;
            this.synthetic = field.synthetic;
            this.name = field.name;
            this.nameNestingDepth = field.nameNestingDepth;
            this.nameNestingConnector = field.nameNestingConnector;
        }
    }

    public final int getNameNestingDepth() {
        return this.nameNestingDepth;
    }

    public void setNameNestingDepth(int nameNestingDepth) {
        this.nameNestingDepth = nameNestingDepth;
    }

    public final String getNameNestingConnector() {
        return this.nameNestingConnector;
    }

    public void setNameNestingConnector(String nameNestingConnector) {
        this.nameNestingConnector = nameNestingConnector;
    }

    @Override
    public Field clone() {
        return new Field(this);
    }

    @Override
    public Field getParent() {
        return this.parent;
    }

    public void setParent(Field parent) {
        this.parent = parent;
    }

    @Override
    public Object get(Object instance) {
        if (this.parent == null) {
            return this.getGetter().get(instance);
        }
        Object parentValue = instance;
        ReversibleIterator enumeration = this.parents().invert();
        while (enumeration.hasNext()) {
            Field parentField = (Field)enumeration.next();
            if (!parentField.isSupportGetter()) {
                return Value.EMPTY.getAsObject(this.getGetter().getType());
            }
            boolean isStatic = Modifier.isStatic(parentField.getGetter().getModifiers());
            if (isStatic) {
                parentValue = null;
                continue;
            }
            if (!ClassUtils.isAssignableValue(parentField.getDeclaringClass(), parentValue)) break;
            parentValue = parentField.getGetter().get(parentValue);
            if (parentValue != null) continue;
            return Value.EMPTY.getAsObject(this.getGetter().getType());
        }
        if (ClassUtils.isAssignableValue(this.getDeclaringClass(), parentValue)) {
            return this.getGetter().get(parentValue);
        }
        return this.getGetter().get(instance);
    }

    @Override
    public void set(Object instance, Object value) {
        if (this.parent == null) {
            this.getSetter().set(instance, value);
            return;
        }
        if (ClassUtils.isAssignableValue(this.getDeclaringClass(), instance)) {
            this.getSetter().set(instance, value);
            return;
        }
        Object parentValue = instance;
        ReversibleIterator enumeration = this.parents().invert();
        while (enumeration.hasNext()) {
            Object target;
            Field parentField = (Field)enumeration.next();
            boolean isStatic = Modifier.isStatic(parentField.getGetter().getModifiers());
            if (isStatic) {
                parentValue = null;
                continue;
            }
            Object object = target = parentField.isSupportGetter() ? parentField.getGetter().get(parentValue) : null;
            if (target == null) {
                if (value == null) {
                    return;
                }
                target = ReflectionApi.newInstance(parentField.getSetter().getType());
                parentField.getSetter().set(parentValue, target);
            }
            parentValue = target;
        }
        if (ClassUtils.isAssignableValue(this.getDeclaringClass(), parentValue)) {
            this.getSetter().set(parentValue, value);
        } else {
            this.getSetter().set(instance, value);
        }
    }

    public <V, E extends Throwable> V getValueByNames(Processor<? super String, ? extends V, ? extends E> processor) throws E {
        V value;
        if (this.isSupportSetter() && (value = processor.process(this.getSetter().getName())) != null) {
            return value;
        }
        if (this.isSupportGetter() && (value = processor.process(this.getGetter().getName())) != null) {
            return value;
        }
        return null;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    private String resolveName() {
        if (this.isSupportGetter()) {
            return this.getGetter().getName();
        }
        if (this.isSupportSetter()) {
            return this.getSetter().getName();
        }
        return null;
    }

    @Override
    public String getName() {
        if (StringUtils.isNotEmpty(this.name)) {
            return this.name;
        }
        String name = this.resolveName();
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        if (this.hasParent() && this.nameNestingDepth > 0) {
            StringBuilder sb = new StringBuilder();
            ReversibleIterator parents = this.parents().invert();
            int i = 0;
            while (parents.hasNext() && i++ < this.nameNestingDepth) {
                Field parent = (Field)parents.next();
                sb.append(parent.getName());
                sb.append(this.nameNestingConnector);
            }
            sb.append(name);
            return sb.toString();
        }
        return name;
    }

    public Collection<String> getAliasNames() {
        if (this.aliasNames != null) {
            return Collections.unmodifiableCollection(this.aliasNames);
        }
        if (this.isSupportGetter() && this.isSupportSetter()) {
            return Arrays.asList(this.getSetter().getName());
        }
        return Collections.emptyList();
    }

    public void setAliasNames(Collection<String> aliasNames) {
        this.aliasNames = aliasNames;
    }

    @Override
    public int getModifiers() {
        if (this.modifiers != null) {
            return this.modifiers;
        }
        if (this.isSupportGetter() && this.isSupportSetter()) {
            return this.getGetter().getModifiers() | this.getSetter().getModifiers();
        }
        if (this.isSupportGetter()) {
            return this.getGetter().getModifiers();
        }
        if (this.isSupportSetter()) {
            return this.getSetter().getModifiers();
        }
        return 0;
    }

    @Override
    public boolean isSynthetic() {
        if (this.synthetic != null) {
            return this.synthetic;
        }
        if (this.isSupportGetter() && this.isSupportSetter()) {
            return this.getGetter().isSynthetic() || this.getSetter().isSynthetic();
        }
        if (this.isSupportGetter()) {
            return this.getGetter().isSynthetic();
        }
        if (this.isSupportSetter()) {
            return this.getSetter().isSynthetic();
        }
        return false;
    }

    public void setModifiers(Integer modifiers) {
        this.modifiers = modifiers;
    }

    public void setSynthetic(Boolean synthetic) {
        this.synthetic = synthetic;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field rename(String name) {
        Field field = this.clone();
        field.setName(name);
        return field;
    }

    public Parameter getParameter(Object instance) {
        return new Parameter(this.getName(), this.get(instance), new TypeDescriptor(this.getGetter()));
    }

    @Override
    public String toString() {
        if (this.parent == null) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("parent[").append(this.parent).append("] ");
        sb.append(super.toString());
        return sb.toString();
    }

    public <T extends Field, E extends Throwable> Structure<T> withEntityTo(Structure<T> structure, @Nullable Processor<Field, Structure<T>, E> processor) throws E {
        if (processor == null) {
            return structure;
        }
        Structure entity = processor.process(this);
        if (entity == null) {
            return structure;
        }
        entity = (Structure)entity.setParentField(this).filter(e -> {
            e.nameNestingDepth = 0;
            return true;
        });
        return (Structure)structure.with(entity);
    }

    private static void appendNames(String prefix, Field field, Collection<String> names, boolean root, String nameConnector, boolean nameNesting, AliasRegistry aliasRegistry) {
        block4: {
            Field parent;
            block3: {
                parent = field.getParent();
                if (parent != null && root && nameNesting && field.nameNestingDepth < 0) break block3;
                names.add(prefix == null ? field.getName() : prefix + field.getName());
                Collection<String> aliasNames = field.getAliasNames();
                if (aliasNames == null) break block4;
                for (String name : aliasNames) {
                    String[] aliasArray;
                    names.add(prefix == null ? name : prefix + name);
                    if (aliasRegistry == null || !aliasRegistry.isAlias(name) || (aliasArray = aliasRegistry.getAliases(name)) == null) continue;
                    for (String alias : aliasArray) {
                        names.add(prefix == null ? alias : prefix + alias);
                    }
                }
                break block4;
            }
            for (String name : parent.getNames(nameNesting, aliasRegistry, prefix, nameConnector)) {
                Field.appendNames(nameConnector == null ? name : name + nameConnector, field, names, false, nameConnector, nameNesting, aliasRegistry);
            }
        }
    }

    protected Collection<String> getNames(boolean nameNesting, @Nullable AliasRegistry aliasRegistry, @Nullable String prefix, @Nullable String nameConnector) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(8);
        Field.appendNames(prefix, this, names, true, nameConnector, nameNesting, aliasRegistry);
        return names;
    }

    public Collection<String> getNames(ObjectMapperContext context) {
        return this.getNames(context.isNameNesting(), context.getAliasRegistry(), context.getNamePrefix(), context.getNameConnector());
    }

    @Override
    public boolean test(Field target) {
        if (target == null) {
            return false;
        }
        if (target.getName().equals(this.getName()) || target.getAliasNames().contains(this.getName())) {
            if (this.isSupportGetter() && target.isSupportSetter()) {
                int sourceModifiers = this.getGetter().getModifiers();
                int targetModifiers = target.getSetter().getModifiers();
                if (Modifier.isStatic(sourceModifiers) ^ Modifier.isStatic(targetModifiers)) {
                    return false;
                }
                ResolvableType type1 = ResolvableType.forType(this.getGetter().getGenericType());
                ResolvableType type2 = ResolvableType.forType(target.getSetter().getGenericType());
                if (!type2.isAssignableFrom(type1)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

