/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.lang.Ignore;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.mapper.Field;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public enum FieldFeature implements Predicate<Field>
{
    SUPPORT_GETTER,
    SUPPORT_SETTER,
    GETTER_PUBLIC,
    SETTER_PUBLIC,
    IGNORE_TRANSIENT,
    IGNORE_STATIC,
    STRICT,
    SETTER,
    GETTER,
    EXISTING_FIELD,
    EXISTING_GETTER_FIELD,
    EXISTING_SETTER_FIELD,
    IGNORE_GETTER_FINAL,
    IGNORE_SETTER_FINAL,
    IGNORE_FINAL,
    IGNORE_ANNOTATION;


    @Override
    public boolean test(Field field) {
        switch (this) {
            case SUPPORT_GETTER: {
                return field.isSupportGetter();
            }
            case SUPPORT_SETTER: {
                return field.isSupportSetter();
            }
            case GETTER_PUBLIC: {
                return field.isSupportGetter() && Modifier.isPublic(field.getGetter().getModifiers());
            }
            case SETTER_PUBLIC: {
                return field.isSupportSetter() && Modifier.isPublic(field.getSetter().getModifiers());
            }
            case IGNORE_STATIC: {
                if (field.isSupportGetter() && Modifier.isStatic(field.getGetter().getModifiers())) {
                    return false;
                }
                return !field.isSupportSetter() || !Modifier.isStatic(field.getSetter().getModifiers());
            }
            case IGNORE_TRANSIENT: {
                if (field.isSupportGetter() && Modifier.isTransient(field.getGetter().getModifiers())) {
                    return false;
                }
                return !field.isSupportSetter() || !Modifier.isTransient(field.getSetter().getModifiers());
            }
            case STRICT: {
                return field.isSupportGetter() && field.isSupportSetter();
            }
            case SETTER: {
                return field.isSupportSetter() && field.getSetter().getField() != null && !Modifier.isStatic(field.getSetter().getField().getModifiers()) && !Modifier.isFinal(field.getSetter().getField().getModifiers());
            }
            case GETTER: {
                return field.isSupportGetter() && !Modifier.isStatic(field.getGetter().getModifiers()) && Modifier.isPublic(field.getGetter().getModifiers());
            }
            case EXISTING_GETTER_FIELD: {
                return field.isSupportGetter() && field.getGetter().getField() != null;
            }
            case EXISTING_SETTER_FIELD: {
                return field.isSupportSetter() && field.getSetter().getField() != null;
            }
            case EXISTING_FIELD: {
                return EXISTING_GETTER_FIELD.test(field) && EXISTING_SETTER_FIELD.test(field);
            }
            case IGNORE_GETTER_FINAL: {
                return !field.isSupportGetter() || field.getGetter().getField() == null || !Modifier.isFinal(field.getGetter().getField().getModifiers());
            }
            case IGNORE_SETTER_FINAL: {
                return !field.isSupportSetter() || field.getSetter().getField() == null || !Modifier.isFinal(field.getSetter().getField().getModifiers());
            }
            case IGNORE_FINAL: {
                if (field.isSupportGetter() && field.getGetter().getField() != null && Modifier.isFinal(field.getGetter().getField().getModifiers())) {
                    return false;
                }
                return !field.isSupportSetter() || field.getSetter().getField() == null || !Modifier.isFinal(field.getSetter().getField().getModifiers());
            }
            case IGNORE_ANNOTATION: {
                return !field.isAnnotationPresent(Ignore.class);
            }
        }
        throw new UnsupportedException(this.toString());
    }
}

