/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.Members;
import io.basc.framework.core.MembersDecorator;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.FieldDescriptor;
import io.basc.framework.mapper.FieldFeature;
import io.basc.framework.mapper.PredicateFieldDescriptor;
import io.basc.framework.util.LinkedMultiValueMap;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.page.Pageable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class FieldsDecorator<S extends Field, T extends FieldsDecorator<S, T>>
extends MembersDecorator<S, T> {
    protected S parent;

    public FieldsDecorator(S parent, Class<?> sourceClass, Function<Class<?>, ? extends Stream<S>> processor) {
        super(sourceClass, processor);
        this.parent = parent;
    }

    public FieldsDecorator(Members<S> members) {
        super(members);
    }

    public FieldsDecorator(FieldsDecorator<S, T> members) {
        super(members);
        this.parent = members.parent;
    }

    public S getParent() {
        return this.parent;
    }

    public T setParent(S parent) {
        Pageable members = this.map((T e) -> {
            Field t = (Field)ReflectionUtils.invokeCloneMethod(e);
            if (t == null) {
                t = e;
            }
            t.setParent((Field)parent);
            return t;
        });
        FieldsDecorator fields = (FieldsDecorator)this.decorate(members);
        fields.parent = parent;
        return (T)fields;
    }

    public T byGetterName(String name, @Nullable Type type) {
        return this.getters(new PredicateFieldDescriptor(name, type));
    }

    public T byName(String name) {
        PredicateFieldDescriptor acceptFieldDescriptor = new PredicateFieldDescriptor(name, null);
        return (T)((FieldsDecorator)this.filter((T e) -> e.isSupportGetter() && acceptFieldDescriptor.test(e.getGetter()) || e.isSupportSetter() && acceptFieldDescriptor.test(e.getSetter())));
    }

    public T byName(String name, @Nullable Type type) {
        PredicateFieldDescriptor acceptFieldDescriptor = new PredicateFieldDescriptor(name, type);
        return (T)((FieldsDecorator)this.filter((T e) -> e.isSupportGetter() && acceptFieldDescriptor.test(e.getGetter()) || e.isSupportSetter() && acceptFieldDescriptor.test(e.getSetter())));
    }

    public T bySetterName(String name, @Nullable Type type) {
        return this.setters(new PredicateFieldDescriptor(name, type));
    }

    public T entity() {
        return ((FieldsDecorator)((FieldsDecorator)this.ignoreStatic()).ignoreTransient()).strict();
    }

    @Override
    public T exclude(Collection<String> names) {
        return (T)((FieldsDecorator)this.exclude((? super S e) -> e.isSupportGetter() && names.contains(e.getGetter().getName()) || e.isSupportSetter() && names.contains(e.getSetter().getName())));
    }

    @Nullable
    public S getByGetterName(String name, @Nullable Type type) {
        return (S)((Field)this.byGetterName(name, type).first());
    }

    @Nullable
    public S getByName(String name, @Nullable Type type) {
        return (S)((Field)this.byName(name, type).first());
    }

    @Nullable
    public S getBySetterName(String name, @Nullable Type type) {
        return (S)((Field)this.bySetterName(name, type).first());
    }

    public MultiValueMap<String, Object> getMultiValueMap(Object instance) {
        LinkedMultiValueMap<String, Object> map = new LinkedMultiValueMap<String, Object>();
        for (Field field : this) {
            Object value;
            if (!field.isSupportGetter() || (value = field.get(instance)) == null) continue;
            map.add(field.getGetter().getName(), value);
        }
        return map;
    }

    public T getters() {
        return (T)((FieldsDecorator)this.filter((Predicate)FieldFeature.SUPPORT_GETTER));
    }

    public T getters(Predicate<? super FieldDescriptor> accept) {
        if (accept == null) {
            return (T)((FieldsDecorator)this.decorate(this));
        }
        return (T)((FieldsDecorator)this.filter((T e) -> e.isSupportGetter() && accept.test(e.getGetter())));
    }

    public Map<String, Object> getValueMap(Object instance) {
        return this.getMultiValueMap(instance).toSingleValueMap();
    }

    public T ignoreFinal() {
        return (T)((FieldsDecorator)this.filter((Predicate)FieldFeature.IGNORE_FINAL));
    }

    public T ignoreStatic() {
        return (T)((FieldsDecorator)this.filter((Predicate)FieldFeature.IGNORE_STATIC));
    }

    public T ignoreTransient() {
        return (T)((FieldsDecorator)this.filter((Predicate)FieldFeature.IGNORE_TRANSIENT));
    }

    public T setters() {
        return (T)((FieldsDecorator)this.filter((Predicate)FieldFeature.SUPPORT_SETTER));
    }

    public T setters(Predicate<? super FieldDescriptor> accept) {
        if (accept == null) {
            return (T)((FieldsDecorator)this.decorate(this));
        }
        return (T)((FieldsDecorator)this.filter((T e) -> e.isSupportSetter() && accept.test(e.getSetter())));
    }

    public T strict() {
        return (T)((FieldsDecorator)this.filter((Predicate)FieldFeature.STRICT));
    }

    public T jumpTo(Class<?> cursorId, S parent) {
        return ((FieldsDecorator)super.jumpTo(cursorId)).setParent(parent);
    }
}

