/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.mapper.ObjectAccess;
import io.basc.framework.mapper.Parameter;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.value.ConfigurablePropertyFactory;
import io.basc.framework.value.PropertyFactory;
import io.basc.framework.value.Value;
import java.util.Collections;
import java.util.Enumeration;

public class PropertyFactoryAccess<E extends Throwable>
implements ObjectAccess<E> {
    private final PropertyFactory propertyFactory;

    public PropertyFactoryAccess(PropertyFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
    }

    @Override
    public Enumeration<String> keys() throws E {
        if (this.propertyFactory == null) {
            return Collections.emptyEnumeration();
        }
        return CollectionUtils.toEnumeration(this.propertyFactory.stream().iterator());
    }

    @Override
    public Parameter get(String name) throws E {
        if (this.propertyFactory == null) {
            return null;
        }
        Value value = this.propertyFactory.get(name);
        return value == null ? null : new Parameter(name, (Object)value);
    }

    @Override
    public void set(Parameter parameter) throws E {
        if (this.propertyFactory == null || !(this.propertyFactory instanceof ConfigurablePropertyFactory)) {
            throw new UnsupportedOperationException(String.valueOf(parameter));
        }
        ((ConfigurablePropertyFactory)this.propertyFactory).put(parameter.getName(), parameter);
    }
}

