/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.Members;
import io.basc.framework.core.MembersDecorator;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.FieldDescriptor;
import io.basc.framework.mapper.FieldFeature;
import io.basc.framework.mapper.PredicateFieldDescriptor;
import io.basc.framework.util.LinkedMultiValueMap;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.XUtils;
import io.basc.framework.util.page.PageablesIterator;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Structure<T extends Field>
extends MembersDecorator<T, Structure<T>> {
    protected String name;
    protected Collection<String> aliasNames;
    private T parent;
    private int nameNestingDepth = -1;
    private String nameNestingConnector = "_";

    public Structure(Members<T> members) {
        super(members);
        if (members instanceof Structure) {
            this.name = ((Structure)members).name;
            this.aliasNames = ((Structure)members).aliasNames;
            this.parent = ((Structure)members).parent;
            this.nameNestingConnector = ((Structure)members).nameNestingConnector;
            this.nameNestingDepth = ((Structure)members).nameNestingDepth;
        }
    }

    public Structure(Class<?> sourceClass, T parent, Function<Class<?>, ? extends Stream<T>> processor) {
        super(sourceClass, processor);
        this.parent = parent;
    }

    public Structure(Members<? extends Field> members, Function<? super Field, ? extends T> map) {
        super(members.map(map));
        if (members instanceof Structure) {
            this.name = ((Structure)members).name;
            this.aliasNames = ((Structure)members).aliasNames;
            this.parent = this.map((Field)map.apply((Field)((Structure)members).parent));
            this.nameNestingConnector = ((Structure)members).nameNestingConnector;
            this.nameNestingDepth = ((Structure)members).nameNestingDepth;
        }
    }

    protected T map(T source) {
        if (this.parent == null) {
            return source;
        }
        if (source == null) {
            return source;
        }
        if (source.hasParent()) {
            return source;
        }
        T t = this.clone(source);
        ((Field)t).setParent((Field)this.parent);
        return t;
    }

    @Override
    public <S> Members<S> mapProcessor(Function<Stream<T>, ? extends Stream<S>> processor) {
        return super.mapProcessor(s -> (Stream)processor.apply(s.map((? super T e) -> this.map(e))));
    }

    @Override
    protected Structure<T> decorate(Members<T> members) {
        Structure<T> structure = new Structure<T>(members);
        if (!(members instanceof Structure)) {
            structure.parent = this.parent;
            structure.aliasNames = this.aliasNames;
            structure.parent = this.parent;
            structure.nameNestingConnector = this.nameNestingConnector;
            structure.nameNestingDepth = this.nameNestingDepth;
        }
        return structure;
    }

    public T getParent() {
        return this.parent;
    }

    protected T clone(T source) {
        Field target = (Field)ReflectionUtils.invokeCloneMethod(source);
        if (target == null) {
            target = source;
        }
        return (T)target;
    }

    public Structure<T> setParent(T parent) {
        if (this.parent == parent) {
            return this.decorate((Members)this);
        }
        Function<Field, Field> members = this.map((T)((Function<Field, Field>)e -> {
            Field t = this.clone(e);
            t.setParent((Field)parent);
            return t;
        }));
        Members structure = this.decorate((Members)((Object)members));
        ((Structure)structure).parent = parent;
        return structure;
    }

    @Override
    public Stream<? extends Structure<T>> pages() {
        return XUtils.stream(new PageablesIterator<Structure>(this, e -> (Structure)e.next()));
    }

    public Structure<T> setNameNestingDepth(int nameNestingDepth) {
        if (this.nameNestingDepth == nameNestingDepth) {
            return this.decorate((Members)this);
        }
        Function<Field, Field> members = this.map((T)((Function<Field, Field>)e -> {
            Field t = this.clone(e);
            t.setNameNestingDepth(nameNestingDepth);
            return t;
        }));
        Members structure = this.decorate((Members)((Object)members));
        ((Structure)structure).nameNestingDepth = nameNestingDepth;
        return structure;
    }

    public int getNameNestingDepth() {
        return this.nameNestingDepth;
    }

    public String getNameNestingConnector() {
        return this.nameNestingConnector;
    }

    public Structure<T> setNameNestingConnector(String nameNestingConnector) {
        if (StringUtils.equals(this.nameNestingConnector, nameNestingConnector)) {
            return this.decorate((Members)this);
        }
        Function<Field, Field> members = this.map((T)((Function<Field, Field>)e -> {
            Field t = this.clone(e);
            t.setNameNestingDepth(this.nameNestingDepth);
            return t;
        }));
        Members structure = this.decorate((Members)((Object)members));
        ((Structure)structure).nameNestingConnector = nameNestingConnector;
        return structure;
    }

    public Structure<T> setParentField(Field parent) {
        if (this.parent == parent) {
            return this.decorate((Members)this);
        }
        Function<Field, Field> members = this.map((T)((Function<Field, Field>)e -> {
            Field t = this.clone(e);
            t.setParent(parent);
            return t;
        }));
        Members structure = this.decorate((Members)((Object)members));
        return structure;
    }

    public String getName() {
        if (StringUtils.isEmpty(this.name)) {
            return StringUtils.toLowerCase(this.getSourceClass().getSimpleName(), 0, 1);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<String> getAliasNames() {
        if (this.aliasNames == null) {
            return Arrays.asList(StringUtils.humpNamingReplacement(StringUtils.toLowerCase(this.getSourceClass().getSimpleName(), 0, 1), "_"));
        }
        return Collections.unmodifiableCollection(this.aliasNames);
    }

    public void setAliasNames(Collection<String> aliasNames) {
        this.aliasNames = aliasNames;
    }

    public Structure<T> byGetterName(String name, @Nullable Type type) {
        return this.getters(new PredicateFieldDescriptor(name, type));
    }

    public Structure<T> byName(String name) {
        PredicateFieldDescriptor acceptFieldDescriptor = new PredicateFieldDescriptor(name, null);
        return (Structure)this.filter((T e) -> e.isSupportGetter() && acceptFieldDescriptor.test(e.getGetter()) || e.isSupportSetter() && acceptFieldDescriptor.test(e.getSetter()));
    }

    public Structure<T> byName(String name, @Nullable Type type) {
        PredicateFieldDescriptor acceptFieldDescriptor = new PredicateFieldDescriptor(name, type);
        return (Structure)this.filter((T e) -> e.isSupportGetter() && acceptFieldDescriptor.test(e.getGetter()) || e.isSupportSetter() && acceptFieldDescriptor.test(e.getSetter()));
    }

    public Structure<T> bySetterName(String name, @Nullable Type type) {
        return this.setters(new PredicateFieldDescriptor(name, type));
    }

    public Structure<T> entity() {
        return this.ignoreStatic().ignoreTransient().strict();
    }

    @Override
    public Structure<T> exclude(Collection<String> names) {
        return (Structure)this.exclude((? super S e) -> e.isSupportGetter() && names.contains(e.getGetter().getName()) || e.isSupportSetter() && names.contains(e.getSetter().getName()));
    }

    @Nullable
    public T getByGetterName(String name, @Nullable Type type) {
        return (T)((Field)this.byGetterName(name, type).first());
    }

    @Nullable
    public T getByName(String name, @Nullable Type type) {
        return (T)((Field)this.byName(name, type).first());
    }

    public T getByName(String name) {
        return this.getByName(name, null);
    }

    @Nullable
    public T getBySetterName(String name, @Nullable Type type) {
        return (T)((Field)this.bySetterName(name, type).first());
    }

    public T getBySetterName(String name) {
        return this.getBySetterName(name, null);
    }

    public MultiValueMap<String, Object> getMultiValueMap(Object instance) {
        LinkedMultiValueMap<String, Object> map = new LinkedMultiValueMap<String, Object>();
        for (Field field : this) {
            Object value;
            if (!field.isSupportGetter() || (value = field.get(instance)) == null) continue;
            map.add(field.getGetter().getName(), value);
        }
        return map;
    }

    public Structure<T> getters() {
        return (Structure)this.filter((Predicate)FieldFeature.SUPPORT_GETTER);
    }

    public Structure<T> getters(Predicate<? super FieldDescriptor> accept) {
        if (accept == null) {
            return this.decorate((Members)this);
        }
        return (Structure)this.filter((T e) -> e.isSupportGetter() && accept.test(e.getGetter()));
    }

    public Map<String, Object> getValueMap(Object instance) {
        return this.getMultiValueMap(instance).toSingleValueMap();
    }

    public Structure<T> ignoreFinal() {
        return (Structure)this.filter((Predicate)FieldFeature.IGNORE_FINAL);
    }

    public Structure<T> ignoreStatic() {
        return (Structure)this.filter((Predicate)FieldFeature.IGNORE_STATIC);
    }

    public Structure<T> ignoreTransient() {
        return (Structure)this.filter((Predicate)FieldFeature.IGNORE_TRANSIENT);
    }

    public Structure<T> setters() {
        return (Structure)this.filter((Predicate)FieldFeature.SUPPORT_SETTER);
    }

    public Structure<T> setters(Predicate<? super FieldDescriptor> accept) {
        if (accept == null) {
            return this;
        }
        return (Structure)this.filter((T e) -> e.isSupportSetter() && accept.test(e.getSetter()));
    }

    public Structure<T> strict() {
        return (Structure)this.filter((Predicate)FieldFeature.STRICT);
    }

    public Structure<T> rename(String name) {
        Structure structure = (Structure)this.clone();
        structure.name = name;
        return structure;
    }
}

