/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.math;

import io.basc.framework.math.MathFunction;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Addition
implements MathFunction<Number, Number> {
    public static final Addition INSTANCE = new Addition();

    @Override
    public Number eval(Number left, Number right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof BigDecimal) {
            if (right instanceof BigDecimal) {
                return ((BigDecimal)left).add((BigDecimal)right);
            }
            if (right instanceof BigInteger) {
                return ((BigDecimal)left).add(new BigDecimal((BigInteger)right));
            }
            if (right instanceof Float || right instanceof Double) {
                return ((BigDecimal)left).add(new BigDecimal(right.doubleValue()));
            }
            return ((BigDecimal)left).add(new BigDecimal(right.longValue()));
        }
        if (left instanceof BigInteger) {
            if (right instanceof BigDecimal) {
                return this.eval(right, left);
            }
            if (right instanceof BigInteger) {
                return ((BigInteger)left).add((BigInteger)right);
            }
            if (right instanceof Float || right instanceof Double) {
                return new BigDecimal((BigInteger)left).add(new BigDecimal(right.doubleValue()));
            }
            return ((BigInteger)left).add(BigInteger.valueOf(right.longValue()));
        }
        if (left instanceof Float || left instanceof Double) {
            if (right instanceof BigDecimal || right instanceof BigInteger) {
                return this.eval(right, left);
            }
            return left.doubleValue() + right.doubleValue();
        }
        if (right instanceof BigDecimal || right instanceof BigInteger || right instanceof Float || right instanceof Double) {
            return this.eval(right, left);
        }
        return left.longValue() + right.longValue();
    }
}

