/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.math;

import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.math.AbstractNumberHolder;
import io.basc.framework.math.Fraction;
import io.basc.framework.math.NumberHolder;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalHolder
extends AbstractNumberHolder {
    private static final long serialVersionUID = 1L;
    public static final BigDecimalHolder ZERO = new BigDecimalHolder(BigDecimal.ZERO);
    private static Logger logger = LoggerFactory.getLogger(BigDecimalHolder.class);
    private static final int DEFAULT_SCALE = 64;
    private static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_EVEN;
    private final BigDecimal bigDecimal;
    private final int scale;
    private final RoundingMode roundingMode;

    public BigDecimalHolder(String number) {
        this(new BigDecimal(number), 64, ROUNDING_MODE);
    }

    public BigDecimalHolder(String number, int scale, RoundingMode roundingMode) {
        this(new BigDecimal(number), scale, roundingMode);
    }

    public BigDecimalHolder(BigDecimal bigDecimal) {
        this(bigDecimal, 64, ROUNDING_MODE);
    }

    public BigDecimalHolder(BigDecimal bigDecimal, int scale, RoundingMode roundingMode) {
        this.bigDecimal = bigDecimal;
        this.roundingMode = roundingMode;
        this.scale = scale;
    }

    public final int getScale() {
        return this.scale;
    }

    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    protected NumberHolder addInternal(NumberHolder numberHolder) {
        return new BigDecimalHolder(this.toBigDecimal().add(numberHolder.toBigDecimal()), this.scale, this.roundingMode);
    }

    @Override
    protected NumberHolder subtractInternal(NumberHolder numberHolder) {
        return new BigDecimalHolder(this.toBigDecimal().subtract(numberHolder.toBigDecimal()), this.scale, this.roundingMode);
    }

    @Override
    protected NumberHolder multiplyInternal(NumberHolder numberHolder) {
        return new BigDecimalHolder(this.toBigDecimal().multiply(numberHolder.toBigDecimal()), this.scale, this.roundingMode);
    }

    @Override
    protected NumberHolder divideInternal(NumberHolder numberHolder) {
        BigDecimal bigDecimal;
        BigDecimal left = this.toBigDecimal();
        BigDecimal right = numberHolder.toBigDecimal();
        try {
            bigDecimal = left.divide(right);
        }
        catch (ArithmeticException e) {
            bigDecimal = left.divide(right, this.scale, this.roundingMode);
            logger.error("{}/{} Compulsory use value {} error:{}", left, right, bigDecimal, e.getMessage());
        }
        return new BigDecimalHolder(bigDecimal, this.scale, this.roundingMode);
    }

    public NumberHolder divide(NumberHolder numberHolder, int scale, RoundingMode roundingMode) {
        if (numberHolder instanceof Fraction) {
            return this.divide((Fraction)numberHolder);
        }
        return new BigDecimalHolder(this.toBigDecimal().divide(numberHolder.toBigDecimal(), scale, roundingMode), scale, roundingMode);
    }

    @Override
    protected NumberHolder remainderInternal(NumberHolder numberHolder) {
        return new BigDecimalHolder(this.toBigDecimal().remainder(numberHolder.toBigDecimal()), this.scale, this.roundingMode);
    }

    @Override
    protected NumberHolder powInternal(NumberHolder numberHolder) {
        return new BigDecimalHolder(this.toBigDecimal().pow(numberHolder.toBigDecimal().intValueExact()), this.scale, this.roundingMode);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return this.bigDecimal;
    }

    @Override
    public String toString() {
        return this.bigDecimal.toString();
    }

    @Override
    public NumberHolder abs() {
        return new BigDecimalHolder(this.bigDecimal.abs());
    }
}

