/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.math;

import io.basc.framework.math.BigDecimalHolder;
import io.basc.framework.math.MathFunction;
import io.basc.framework.math.NumberHolder;
import io.basc.framework.util.Assert;
import java.math.BigDecimal;

public interface Calculator
extends MathFunction<NumberHolder, NumberHolder> {
    @Override
    default public NumberHolder eval(String left, String right) {
        Assert.requiredArgument(left != null, "left");
        Assert.requiredArgument(right != null, "right");
        return (NumberHolder)this.eval(new BigDecimalHolder(left), new BigDecimalHolder(right));
    }

    @Override
    default public NumberHolder eval(BigDecimal left, BigDecimal right) {
        Assert.requiredArgument(left != null, "left");
        Assert.requiredArgument(right != null, "right");
        return (NumberHolder)this.eval(new BigDecimalHolder(left), new BigDecimalHolder(right));
    }

    @Override
    default public NumberHolder eval(BigDecimal left, String right) {
        Assert.requiredArgument(left != null, "left");
        Assert.requiredArgument(right != null, "right");
        return (NumberHolder)this.eval(new BigDecimalHolder(left), new BigDecimalHolder(right));
    }

    public String getOperator();
}

