/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net;

import io.basc.framework.lang.Constants;
import io.basc.framework.net.InvalidMimeTypeException;
import io.basc.framework.net.MimeType;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;

public final class MimeTypeUtils {
    private static final byte[] BOUNDARY_CHARS = new byte[]{45, 95, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final Random RND = new SecureRandom();
    public static Charset US_ASCII = Constants.US_ASCII;
    public static final Comparator<MimeType> SPECIFICITY_COMPARATOR = new MimeType.SpecificityComparator<MimeType>();
    public static final MimeType ALL;
    public static final String ALL_VALUE = "*/*";
    public static final MimeType APPLICATION_ATOM_XML;
    public static final String APPLICATION_ATOM_XML_VALUE = "application/atom+xml";
    public static final MimeType APPLICATION_FORM_URLENCODED;
    public static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final MimeType TEXT_JSON;
    public static final String TEXT_JSON_VALUE = "text/json";
    public static final MimeType APPLICATION_JSON;
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final MimeType APPLICATION_OCTET_STREAM;
    public static final String APPLICATION_OCTET_STREAM_VALUE = "application/octet-stream";
    public static final MimeType APPLICATION_XHTML_XML;
    public static final String APPLICATION_XHTML_XML_VALUE = "application/xhtml+xml";
    public static final MimeType APPLICATION_XML;
    public static final String APPLICATION_XML_VALUE = "application/xml";
    public static final MimeType IMAGE_GIF;
    public static final String IMAGE_GIF_VALUE = "image/gif";
    public static final MimeType IMAGE_JPEG;
    public static final String IMAGE_JPEG_VALUE = "image/jpeg";
    public static final MimeType IMAGE_PNG;
    public static final String IMAGE_PNG_VALUE = "image/png";
    public static final MimeType MULTIPART_FORM_DATA;
    public static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    public static final MimeType TEXT_HTML;
    public static final String TEXT_HTML_VALUE = "text/html";
    public static final MimeType TEXT_PLAIN;
    public static final String TEXT_PLAIN_VALUE = "text/plain";
    public static final MimeType TEXT_XML;
    public static final String TEXT_XML_VALUE = "text/xml";
    public static final MimeType APPLICATION_X_WWW_FORM_URLENCODED;
    public static final String APPLICATION_X_WWW_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final MimeType TEXT_JAVASCRIPT;
    public static final String TEXT_JAVASCRIPT_VALUE = "text/javascript";

    public static MimeType parseMimeType(String mimeType) {
        int nextIndex;
        int subIndex;
        if (StringUtils.isEmpty(mimeType)) {
            throw new InvalidMimeTypeException(mimeType, "'mimeType' must not be empty");
        }
        int index = mimeType.indexOf(59);
        String fullType = (index >= 0 ? mimeType.substring(0, index) : mimeType).trim();
        if (fullType.isEmpty()) {
            throw new InvalidMimeTypeException(mimeType, "'mimeType' must not be empty");
        }
        if ("*".equals(fullType)) {
            fullType = ALL_VALUE;
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new InvalidMimeTypeException(mimeType, "does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new InvalidMimeTypeException(mimeType, "does not contain subtype after '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1, fullType.length());
        if ("*".equals(type) && !"*".equals(subtype)) {
            throw new InvalidMimeTypeException(mimeType, "wildcard type is legal only in '*/*' (all mime types)");
        }
        LinkedHashMap<String, String> parameters = null;
        do {
            int eqIndex;
            String parameter;
            boolean quoted = false;
            for (nextIndex = index + 1; nextIndex < mimeType.length(); ++nextIndex) {
                char ch = mimeType.charAt(nextIndex);
                if (ch == ';') {
                    if (quoted) continue;
                    break;
                }
                if (ch != '\"') continue;
                quoted = !quoted;
            }
            if ((parameter = mimeType.substring(index + 1, nextIndex).trim()).length() <= 0) continue;
            if (parameters == null) {
                parameters = new LinkedHashMap<String, String>(4);
            }
            if ((eqIndex = parameter.indexOf(61)) < 0) continue;
            String attribute = parameter.substring(0, eqIndex).trim();
            String value = parameter.substring(eqIndex + 1, parameter.length()).trim();
            parameters.put(attribute, value);
        } while ((index = nextIndex) < mimeType.length());
        try {
            return new MimeType(type, subtype, parameters);
        }
        catch (UnsupportedCharsetException ex) {
            throw new InvalidMimeTypeException(mimeType, "unsupported charset '" + ex.getCharsetName() + "'");
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidMimeTypeException(mimeType, ex.getMessage());
        }
    }

    public static List<MimeType> parseMimeTypes(String mimeTypes) {
        if (StringUtils.isEmpty(mimeTypes)) {
            return Collections.emptyList();
        }
        String[] tokens = StringUtils.tokenizeToArray(mimeTypes, ",");
        ArrayList<MimeType> result = new ArrayList<MimeType>(tokens.length);
        for (String token : tokens) {
            result.add(MimeTypeUtils.parseMimeType(token));
        }
        return result;
    }

    public static String toString(Collection<? extends MimeType> mimeTypes) {
        StringBuilder builder = new StringBuilder();
        Iterator<? extends MimeType> iterator = mimeTypes.iterator();
        while (iterator.hasNext()) {
            MimeType mimeType = iterator.next();
            mimeType.appendTo(builder);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static void sortBySpecificity(List<MimeType> mimeTypes) {
        Assert.notNull(mimeTypes, "'mimeTypes' must not be null");
        if (mimeTypes.size() > 1) {
            Collections.sort(mimeTypes, SPECIFICITY_COMPARATOR);
        }
    }

    public static byte[] generateMultipartBoundary() {
        byte[] boundary = new byte[RND.nextInt(11) + 30];
        for (int i = 0; i < boundary.length; ++i) {
            boundary[i] = BOUNDARY_CHARS[RND.nextInt(BOUNDARY_CHARS.length)];
        }
        return boundary;
    }

    public static List<MimeType> parseMimeTypes(List<String> mimeTypes) {
        if (CollectionUtils.isEmpty(mimeTypes)) {
            return Collections.emptyList();
        }
        if (mimeTypes.size() == 1) {
            return MimeTypeUtils.parseMimeTypes(mimeTypes.get(0));
        }
        ArrayList<MimeType> result = new ArrayList<MimeType>(8);
        for (String mediaType : mimeTypes) {
            result.addAll(MimeTypeUtils.parseMimeTypes(mediaType));
        }
        return result;
    }

    public static String generateMultipartBoundaryString() {
        return new String(MimeTypeUtils.generateMultipartBoundary(), US_ASCII);
    }

    static {
        TEXT_JSON = new MimeType("text", "json");
        APPLICATION_X_WWW_FORM_URLENCODED = new MimeType("application", "x-www-form-urlencoded");
        TEXT_JAVASCRIPT = new MimeType("text", "javascript");
        ALL = MimeType.valueOf(ALL_VALUE);
        APPLICATION_ATOM_XML = MimeType.valueOf(APPLICATION_ATOM_XML_VALUE);
        APPLICATION_FORM_URLENCODED = MimeType.valueOf("application/x-www-form-urlencoded");
        APPLICATION_JSON = MimeType.valueOf(APPLICATION_JSON_VALUE);
        APPLICATION_OCTET_STREAM = MimeType.valueOf(APPLICATION_OCTET_STREAM_VALUE);
        APPLICATION_XHTML_XML = MimeType.valueOf(APPLICATION_XHTML_XML_VALUE);
        APPLICATION_XML = MimeType.valueOf(APPLICATION_XML_VALUE);
        IMAGE_GIF = MimeType.valueOf(IMAGE_GIF_VALUE);
        IMAGE_JPEG = MimeType.valueOf(IMAGE_JPEG_VALUE);
        IMAGE_PNG = MimeType.valueOf(IMAGE_PNG_VALUE);
        MULTIPART_FORM_DATA = MimeType.valueOf(MULTIPART_FORM_DATA_VALUE);
        TEXT_HTML = MimeType.valueOf(TEXT_HTML_VALUE);
        TEXT_PLAIN = MimeType.valueOf(TEXT_PLAIN_VALUE);
        TEXT_XML = MimeType.valueOf(TEXT_XML_VALUE);
    }
}

