/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.message.convert;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.env.Sys;
import io.basc.framework.io.IOUtils;
import io.basc.framework.json.JsonSupportAccessor;
import io.basc.framework.net.MimeType;
import io.basc.framework.net.MimeTypeUtils;
import io.basc.framework.net.MimeTypes;
import io.basc.framework.net.message.Headers;
import io.basc.framework.net.message.InputMessage;
import io.basc.framework.net.message.Message;
import io.basc.framework.net.message.OutputMessage;
import io.basc.framework.net.message.convert.MessageConvertException;
import io.basc.framework.net.message.convert.MessageConverter;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class AbstractMessageConverter<T>
extends JsonSupportAccessor
implements MessageConverter {
    public static final MimeType TEXT_ALL = new MimeType("text", "*");
    private Charset charset;
    protected final MimeTypes supportMimeTypes = new MimeTypes();
    private boolean supportBytes = false;

    public boolean isSupportBytes() {
        return this.supportBytes;
    }

    public void setSupportBytes(boolean supportBytes) {
        this.supportBytes = supportBytes;
    }

    @Override
    public final MimeTypes getSupportMimeTypes() {
        return this.supportMimeTypes.readyOnly();
    }

    public Charset getCharset() {
        return this.charset == null ? Sys.getEnv().getCharset() : this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean canRead(MimeType contentType) {
        if (contentType == null) {
            return true;
        }
        for (MimeType mimeType : this.getSupportMimeTypes()) {
            if (!mimeType.includes(contentType)) continue;
            return true;
        }
        return false;
    }

    public boolean canWrite(MimeType contentType) {
        if (contentType == null || MimeTypeUtils.ALL.equalsTypeAndSubtype(contentType)) {
            return true;
        }
        for (MimeType mimeType : this.getSupportMimeTypes()) {
            if (!mimeType.isCompatibleWith(contentType)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean support(Class<?> var1);

    public boolean canWrite(TypeDescriptor type) {
        return this.support(type.getResolvableType().getRawClass());
    }

    public boolean canRead(TypeDescriptor type) {
        return this.support(type.getResolvableType().getRawClass());
    }

    @Override
    public boolean canRead(TypeDescriptor type, MimeType contentType) {
        if (type.isArray() && type.getResolvableType().getComponentType().getRawClass() == Byte.TYPE && !this.isSupportBytes()) {
            return false;
        }
        return this.canRead(type) && this.canRead(contentType);
    }

    @Override
    public boolean canWrite(TypeDescriptor type, Object body, MimeType contentType) {
        if (body == null) {
            return false;
        }
        if (body.getClass() == byte[].class && !this.isSupportBytes()) {
            return false;
        }
        return this.canWrite(type) && this.canWrite(contentType);
    }

    @Override
    public Object read(TypeDescriptor type, InputMessage inputMessage) throws IOException, MessageConvertException {
        return this.readInternal(type, inputMessage);
    }

    @Override
    public void write(TypeDescriptor type, Object body, MimeType contentType, OutputMessage outputMessage) throws IOException, MessageConvertException {
        Long contentLength;
        Headers headers;
        Object t = body;
        MimeType contentTypeToUse = contentType;
        if (contentType == null) {
            contentTypeToUse = outputMessage.getContentType();
        } else if (outputMessage.getContentType() == null) {
            if (contentTypeToUse == null || contentTypeToUse.isWildcardType() || contentTypeToUse.isWildcardSubtype()) {
                contentTypeToUse = this.getDefaultContentType(type, t);
            }
            if (contentTypeToUse != null && !contentTypeToUse.isWildcardType() && !contentTypeToUse.isWildcardSubtype()) {
                Charset defaultCharset;
                if (contentTypeToUse.getCharset() == null && (defaultCharset = this.getCharset()) != null) {
                    contentTypeToUse = new MimeType(contentTypeToUse, defaultCharset);
                }
                outputMessage.setContentType(contentTypeToUse);
            }
        }
        if (outputMessage.getContentLength() < 0L && (headers = outputMessage.getHeaders()) != null && headers.containsKey("Transfer-Encoding") && (contentLength = this.getContentLength(t, outputMessage.getContentType())) != null && contentLength >= 0L) {
            outputMessage.setContentLength(contentLength);
        }
        this.writeInternal(type, t, contentTypeToUse, outputMessage);
    }

    protected MimeType getDefaultContentType(TypeDescriptor type, T body) throws IOException {
        MimeType mimeType = this.getSupportMimeTypes().getMimeTypes().first();
        if (mimeType.isWildcardType() || mimeType.isWildcardSubtype()) {
            return null;
        }
        return mimeType;
    }

    protected Long getContentLength(T body, MimeType contentType) throws IOException {
        return null;
    }

    protected Charset getCharset(Message message) {
        MimeType mimeType = message.getContentType();
        if (mimeType == null) {
            return this.getCharset();
        }
        Charset charset = mimeType.getCharset();
        if (charset == null) {
            return this.getCharset();
        }
        return charset;
    }

    protected String readTextBody(InputMessage inputMessage) throws IOException {
        return IOUtils.toString(inputMessage.getInputStream(), this.getCharset(inputMessage).name());
    }

    protected void writeTextBody(String text, MimeType contentType, OutputMessage outputMessage) throws IOException {
        if (text == null) {
            return;
        }
        IOUtils.write(text, outputMessage.getOutputStream(), this.getCharset(outputMessage).name());
    }

    protected abstract T readInternal(TypeDescriptor var1, InputMessage var2) throws IOException, MessageConvertException;

    protected abstract void writeInternal(TypeDescriptor var1, T var2, MimeType var3, OutputMessage var4) throws IOException, MessageConvertException;
}

