/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.message.convert;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.json.JsonSupport;
import io.basc.framework.mapper.MapperUtils;
import io.basc.framework.mapper.ToMap;
import io.basc.framework.net.MimeType;
import io.basc.framework.net.MimeTypeUtils;
import io.basc.framework.net.message.InputMessage;
import io.basc.framework.net.message.OutputMessage;
import io.basc.framework.net.message.convert.AbstractMessageConverter;
import io.basc.framework.net.message.convert.MessageConvertException;
import java.io.IOException;

public final class JsonMessageConverter
extends AbstractMessageConverter<Object> {
    public static final MimeType JSON_ALL = new MimeType("application", "*+json");

    public JsonMessageConverter() {
        this.supportMimeTypes.add(MimeTypeUtils.APPLICATION_JSON, JSON_ALL, TEXT_ALL);
    }

    @Override
    public boolean support(Class<?> clazz) {
        return true;
    }

    @Override
    protected Object readInternal(TypeDescriptor type, InputMessage inputMessage) throws IOException, MessageConvertException {
        String text = this.readTextBody(inputMessage);
        if (text == null) {
            return null;
        }
        return this.getJsonSupport().parseObject(text, type.getType());
    }

    @Override
    protected void writeInternal(TypeDescriptor type, Object body, MimeType contentType, OutputMessage outputMessage) throws IOException, MessageConvertException {
        String text = JsonMessageConverter.toJsonString(body, this.getJsonSupport());
        if (text == null) {
            return;
        }
        this.writeTextBody(text, contentType, outputMessage);
    }

    public static String toJsonString(Object body, JsonSupport jsonSupport) {
        if (body == null) {
            return null;
        }
        if (body instanceof ToMap) {
            return jsonSupport.toJsonString(MapperUtils.toMap(body));
        }
        return jsonSupport.toJsonString(body);
    }
}

