/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.message.multipart;

import io.basc.framework.io.AbstractResource;
import io.basc.framework.lang.Nullable;
import io.basc.framework.net.message.multipart.MultipartMessage;
import io.basc.framework.util.Assert;
import java.io.IOException;
import java.io.InputStream;

class MultipartFileResource
extends AbstractResource {
    private final MultipartMessage multipartMessage;

    public MultipartFileResource(MultipartMessage multipartMessage) {
        Assert.notNull((Object)multipartMessage, "MultipartMessage must not be null");
        this.multipartMessage = multipartMessage;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public long contentLength() {
        return this.multipartMessage.getSize();
    }

    @Override
    public String getName() {
        return this.multipartMessage.getOriginalFilename();
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        return this.multipartMessage.getInputStream();
    }

    @Override
    public String getDescription() {
        return "MultipartFile resource [" + this.multipartMessage.getName() + "]";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof MultipartFileResource && ((MultipartFileResource)other).multipartMessage.equals(this.multipartMessage);
    }

    @Override
    public int hashCode() {
        return this.multipartMessage.hashCode();
    }
}

