/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.uri;

import io.basc.framework.codec.Encoder;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.MapperUtils;
import io.basc.framework.net.uri.HierarchicalUriComponents;
import io.basc.framework.net.uri.UriComponentsBuilder;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.StringUtils;
import io.basc.framework.value.Value;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class UriUtils {
    public static final String QUERY_CONNECTOR = "?";
    public static final String PARAMETER_CONNECTOR = "&";
    public static final String NAME_VALUE_CONNECTOR = "=";

    public static String encodeScheme(String scheme, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(scheme, encoding, HierarchicalUriComponents.Type.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(authority, encoding, HierarchicalUriComponents.Type.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(userInfo, encoding, HierarchicalUriComponents.Type.USER_INFO);
    }

    public static String encodeHost(String host, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(host, encoding, HierarchicalUriComponents.Type.HOST_IPV4);
    }

    public static String encodePort(String port, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(port, encoding, HierarchicalUriComponents.Type.PORT);
    }

    public static String encodePath(String path, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(path, encoding, HierarchicalUriComponents.Type.PATH);
    }

    public static String encodePathSegment(String segment, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(segment, encoding, HierarchicalUriComponents.Type.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(query, encoding, HierarchicalUriComponents.Type.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(queryParam, encoding, HierarchicalUriComponents.Type.QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(fragment, encoding, HierarchicalUriComponents.Type.FRAGMENT);
    }

    public static String extractFileExtension(String path) {
        int begin;
        int paramIndex;
        int extIndex;
        int end = path.indexOf(63);
        int fragmentIndex = path.indexOf(35);
        if (fragmentIndex != -1 && (end == -1 || fragmentIndex < end)) {
            end = fragmentIndex;
        }
        if (end == -1) {
            end = path.length();
        }
        if ((extIndex = path.lastIndexOf(46, end = (paramIndex = path.indexOf(59, begin = path.lastIndexOf(47, end) + 1)) != -1 && paramIndex < end ? paramIndex : end)) != -1 && extIndex > begin) {
            return path.substring(extIndex + 1, end);
        }
        return null;
    }

    public static MultiValueMap<String, String> getQueryParams(String uri) {
        if (!StringUtils.hasText(uri)) {
            return CollectionUtils.emptyMultiValueMap();
        }
        int index = uri.indexOf(QUERY_CONNECTOR);
        String queryString = index == -1 ? uri : uri.substring(index + 1);
        index = queryString.indexOf("#");
        if (index != -1) {
            queryString = queryString.substring(0, index - 1);
        }
        return UriComponentsBuilder.newInstance().query(queryString).build().getQueryParams();
    }

    public static String toQueryString(Object body, @Nullable Encoder<String, String> encoder) {
        return UriUtils.toQueryString(body, encoder, PARAMETER_CONNECTOR, NAME_VALUE_CONNECTOR);
    }

    public static String toQueryString(Object body, @Nullable Encoder<String, String> encoder, @Nullable String parameterConnector, @Nullable String nameValueConnector) {
        if (body == null) {
            return null;
        }
        if (Value.isBaseType(body.getClass())) {
            return body.toString();
        }
        return UriUtils.toQueryString(MapperUtils.toMap(body), encoder, parameterConnector, nameValueConnector);
    }

    private static String toQueryString(String key, Collection values, @Nullable Encoder<String, String> encoder, @Nullable String parameterConnector, @Nullable String nameValueConnector) {
        if (StringUtils.isEmpty(key) || CollectionUtils.isEmpty(values)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            if (value == null) continue;
            if (sb.length() > 0 && parameterConnector != null) {
                sb.append(parameterConnector);
            }
            sb.append(key);
            if (nameValueConnector != null) {
                sb.append(nameValueConnector);
            }
            if (encoder != null) {
                sb.append(encoder.encode(value.toString()));
                continue;
            }
            sb.append(value.toString());
        }
        return sb.toString();
    }

    public static String toQueryString(Map parameterMap, @Nullable Encoder<String, String> encoder) {
        return UriUtils.toQueryString(parameterMap, encoder, PARAMETER_CONNECTOR, NAME_VALUE_CONNECTOR);
    }

    public static String toQueryString(Map parameterMap, @Nullable Encoder<String, String> encoder, @Nullable String parameterConnector, @Nullable String nameValueConnector) {
        if (CollectionUtils.isEmpty(parameterMap)) {
            return null;
        }
        Map parameters = CollectionUtils.sort(parameterMap);
        StringBuilder sb = new StringBuilder();
        Set entries = parameters.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey().toString();
            String text = value instanceof Collection ? UriUtils.toQueryString(key, (Collection)value, encoder, parameterConnector, nameValueConnector) : (value.getClass().isArray() ? UriUtils.toQueryString(key, ArrayUtils.toList(value), encoder, parameterConnector, nameValueConnector) : UriUtils.toQueryString(key, Arrays.asList(value), encoder, parameterConnector, nameValueConnector));
            if (text == null) continue;
            if (sb.length() != 0 && parameterConnector != null) {
                sb.append(parameterConnector);
            }
            sb.append(text);
        }
        return sb.toString();
    }

    public static String appendQueryParams(String url, Map<String, ?> paramMap, @Nullable Encoder<String, String> encoder) {
        String text;
        if (paramMap == null || paramMap.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(128);
        if (!StringUtils.isEmpty(url)) {
            sb.append(url);
            if (url.lastIndexOf(QUERY_CONNECTOR) == -1) {
                sb.append(QUERY_CONNECTOR);
            } else {
                sb.append(PARAMETER_CONNECTOR);
            }
        }
        if ((text = UriUtils.toQueryString(paramMap, encoder, PARAMETER_CONNECTOR, NAME_VALUE_CONNECTOR)) != null) {
            sb.append(text);
        }
        return sb.toString();
    }

    public static String encode(String source, String charsetName) {
        if (source == null) {
            return null;
        }
        try {
            return URLEncoder.encode(source, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to encode URI variable", e);
        }
    }

    public static String encode(String source) {
        return UriUtils.encode(source, "UTF-8");
    }

    public static String decode(String source, String charsetName) {
        if (source == null) {
            return null;
        }
        try {
            return URLDecoder.decode(source, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to decode URI variable", e);
        }
    }

    public static String decode(String source) {
        return UriUtils.decode(source, "UTF-8");
    }

    public static boolean isUri(String uri) {
        if (StringUtils.isEmpty(uri)) {
            return false;
        }
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static URI toUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to URI [" + uri + "]", e);
        }
    }
}

