/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.retry.support;

import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.retry.ExhaustedRetryException;
import io.basc.framework.retry.RecoveryCallback;
import io.basc.framework.retry.RetryCallback;
import io.basc.framework.retry.RetryContext;
import io.basc.framework.retry.RetryException;
import io.basc.framework.retry.RetryListener;
import io.basc.framework.retry.RetryOperations;
import io.basc.framework.retry.RetryPolicy;
import io.basc.framework.retry.policy.SimpleRetryPolicy;
import io.basc.framework.retry.support.RetrySynchronizationManager;

public class RetryTemplate
implements RetryOperations {
    public static final RetryOperations DEFAULT = new RetryTemplate();
    private static Logger logger = LoggerFactory.getLogger(RetryTemplate.class);
    private volatile RetryListener[] listeners = new RetryListener[0];
    private final RetryPolicy retryPolicy;
    private boolean throwLastExceptionOnExhausted;

    public RetryTemplate() {
        this(new SimpleRetryPolicy());
    }

    public RetryTemplate(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public final boolean isThrowLastExceptionOnExhausted() {
        return this.throwLastExceptionOnExhausted;
    }

    public void setThrowLastExceptionOnExhausted(boolean throwLastExceptionOnExhausted) {
        this.throwLastExceptionOnExhausted = throwLastExceptionOnExhausted;
    }

    public final RetryListener[] getListeners() {
        return (RetryListener[])this.listeners.clone();
    }

    public void setListeners(RetryListener[] listeners) {
        this.listeners = listeners == null ? new RetryListener[]{} : listeners;
    }

    @Override
    public final <T, E extends Throwable> T execute(RetryCallback<T, E> retryCallback) throws E, RetryException {
        return this.execute(retryCallback, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T, E extends Throwable> T execute(RetryCallback<T, E> retryCallback, @Nullable RecoveryCallback<T, E> recoveryCallback) throws E, RetryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected RetryContext open(RetryPolicy retryPolicy) {
        return retryPolicy.open(RetrySynchronizationManager.getContext());
    }

    protected void registerThrowable(RetryPolicy retryPolicy, RetryContext context, Throwable e) {
        retryPolicy.registerThrowable(context, e);
    }

    protected void close(RetryPolicy retryPolicy, RetryContext context, boolean succeeded) {
        retryPolicy.close(context);
    }

    private <T, E extends Throwable> boolean doOpenInterceptors(RetryCallback<T, E> callback, RetryContext context) {
        boolean result = true;
        for (RetryListener listener : this.listeners) {
            result = result && listener.open(context, callback);
        }
        return result;
    }

    protected <T, E extends Throwable> T handleRetryExhausted(RecoveryCallback<T, E> recoveryCallback, RetryContext context) throws Throwable {
        if (recoveryCallback != null) {
            return recoveryCallback.recover(context);
        }
        logger.debug("Retry exhausted after last attempt with no recovery path.");
        this.rethrow(context, "Retry exhausted after last attempt with no recovery path");
        throw RetryTemplate.wrapIfNecessary(context.getLastThrowable());
    }

    protected boolean canRetry(RetryPolicy retryPolicy, RetryContext context) {
        return retryPolicy.canRetry(context);
    }

    protected <E extends Throwable> void rethrow(RetryContext context, String message) throws E {
        if (this.throwLastExceptionOnExhausted) {
            Throwable rethrow = context.getLastThrowable();
            throw rethrow;
        }
        throw new ExhaustedRetryException(message, context.getLastThrowable());
    }

    private <T, E extends Throwable> void doCloseInterceptors(RetryCallback<T, E> callback, RetryContext context, Throwable lastException) {
        int i = this.listeners.length;
        while (i-- > 0) {
            this.listeners[i].close(context, callback, lastException);
        }
    }

    private <T, E extends Throwable> void doOnErrorInterceptors(RetryCallback<T, E> callback, RetryContext context, Throwable throwable) {
        int i = this.listeners.length;
        while (i-- > 0) {
            this.listeners[i].onError(context, callback, throwable);
        }
    }

    private static <E extends Throwable> E wrapIfNecessary(Throwable throwable) throws RetryException {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof Exception) {
            Throwable rethrow = throwable;
            return (E)rethrow;
        }
        throw new RetryException("Exception in batch process", throwable);
    }
}

