/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Optional;
import io.basc.framework.util.Source;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractOptional<T>
implements Optional<T> {
    @Nullable
    protected abstract T getValue();

    @Override
    public T get() {
        T value = this.getValue();
        if (value == null) {
            throw this.noSuchElement();
        }
        return value;
    }

    protected RuntimeException noSuchElement() {
        return new NoSuchElementException("No value present");
    }

    @Override
    public boolean isPresent() {
        return this.getValue() != null;
    }

    @Override
    public T orElse(T other) {
        T value = this.getValue();
        return value == null ? other : value;
    }

    @Override
    public <E extends Throwable> T orElseGet(Source<? extends T, ? extends E> other) throws E {
        T value = this.getValue();
        return value == null ? other.get() : value;
    }

    @Override
    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        T value = this.getValue();
        if (value != null) {
            return value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Override
    public <E extends Throwable> void ifPresent(ConsumeProcessor<? super T, ? extends E> consumer) throws E {
        T value = this.getValue();
        if (value != null) {
            consumer.process(value);
        }
    }

    @Override
    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        T value = this.getValue();
        if (value == null) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(value));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractOptional)) {
            return false;
        }
        AbstractOptional other = (AbstractOptional)obj;
        return Objects.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.getValue());
    }

    public String toString() {
        T value = this.getValue();
        return this.isPresent() ? String.format("Optional[%s]", value) : "Optional.empty";
    }
}

