/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.CacheableSource;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Source;
import java.util.function.Supplier;

public class CacheableSupplier<T>
extends CacheableSource<T, RuntimeException>
implements Supplier<T> {
    public CacheableSupplier(T source) {
        super(source);
    }

    public CacheableSupplier(Supplier<? extends T> supplier, Object lock) {
        super(new InternalSource<T>(supplier), lock);
    }

    private static class InternalSource<V>
    implements Source<V, RuntimeException> {
        private final Supplier<? extends V> supplier;

        public InternalSource(Supplier<? extends V> supplier) {
            Assert.requiredArgument(supplier != null, "supplier");
            this.supplier = supplier;
        }

        @Override
        public V get() {
            return this.supplier.get();
        }

        public String toString() {
            return this.supplier.toString();
        }

        public int hashCode() {
            return this.supplier.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof InternalSource) {
                return ObjectUtils.equals(this.supplier, ((InternalSource)obj).supplier);
            }
            return false;
        }
    }
}

