/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassLoaderProvider;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.JavaVersion;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.page.Pageables;
import io.basc.framework.util.page.SharedPageable;
import io.basc.framework.util.page.StreamPageables;
import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    public static final String CLASS_FILE_SUFFIX = ".class";
    private static final Map<String, Class<?>> commonClassCache = new HashMap(32);
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    public static final String GENERIC_PREFIX = "<";
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(8);
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(8);

    public static String addResourcePathToPackagePath(Class<?> clazz, String resourceName) {
        Assert.notNull((Object)resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classNamesToString(Class ... classes) {
        return ClassUtils.classNamesToString(Arrays.asList(classes));
    }

    public static String classNamesToString(Collection<Class> classes) {
        if (CollectionUtils.isEmpty(classes)) {
            return ARRAY_SUFFIX;
        }
        StringBuilder sb = new StringBuilder(INTERNAL_ARRAY_PREFIX);
        Iterator<Class> it = classes.iterator();
        while (it.hasNext()) {
            Class clazz = it.next();
            sb.append(clazz.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String classPackageAsResourcePath(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static String convertClassNameToResourcePath(String className) {
        Assert.notNull((Object)className, "Class name must not be null");
        return className.replace('.', '/');
    }

    public static String convertResourcePathToClassName(String resourcePath) {
        Assert.notNull((Object)resourcePath, "Resource path must not be null");
        return resourcePath.replace('/', '.');
    }

    public static Class<?> determineCommonAncestor(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz2;
        }
        Class<?> ancestor = clazz1;
        do {
            if ((ancestor = ancestor.getSuperclass()) != null && Object.class != ancestor) continue;
            return null;
        } while (!ancestor.isAssignableFrom(clazz2));
        return ancestor;
    }

    public static <T> Class<T>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static Class<?> forName(String name, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull((Object)name, "Name must not be null");
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz == null) {
            clazz = commonClassCache.get(name);
        }
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        int end = name.indexOf(GENERIC_PREFIX);
        if (end != -1) {
            int begin = name.lastIndexOf(" ", end);
            return ClassUtils.forName(name.substring(begin == -1 ? 0 : begin + 1, end), classLoader);
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassUtils.getDefaultClassLoader();
        }
        try {
            return ClassUtils.forName0(name, classLoaderToUse);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                return ClassUtils.forName0(innerClassName, classLoaderToUse);
            }
            throw ex;
        }
    }

    private static Class<?> forName0(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, false, classLoader);
    }

    public static Class<?>[] forNames(ClassLoader classLoader, String ... className) throws ClassNotFoundException {
        if (ArrayUtils.isEmpty(className)) {
            return new Class[0];
        }
        Class[] types = new Class[className.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ClassUtils.forName(className[i], classLoader);
        }
        return types;
    }

    public static Class[] getAllInterfaces(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Set<Class> getAllInterfacesAsSet(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        Set<Class> ifcs = ClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader);
        return ifcs.toArray(new Class[ifcs.size()]);
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz, ClassLoader classLoader) {
        Assert.notNull((Object)clazz, "Class must not be null");
        if (clazz.isInterface() && ClassUtils.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        while (clazz != null) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                interfaces.addAll(ClassUtils.getAllInterfacesForClassAsSet(ifc, classLoader));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    @Nullable
    public static Class<?> getClass(String className, @Nullable ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            clazz = ClassUtils.forName(className, classLoader);
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz;
    }

    public static String getClassFileName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    public static ClassLoader getClassLoader(ClassLoaderProvider classLoaderProvider) {
        ClassLoader classLoader = classLoaderProvider == null ? null : classLoaderProvider.getClassLoader();
        return classLoader == null ? ClassUtils.getDefaultClassLoader() : classLoader;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl;
    }

    public static String getDescriptiveType(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        if (Proxy.isProxyClass(clazz)) {
            StringBuilder result = new StringBuilder(clazz.getName());
            result.append(" implementing ");
            Class<?>[] ifcs = clazz.getInterfaces();
            for (int i = 0; i < ifcs.length; ++i) {
                result.append(ifcs[i].getName());
                if (i >= ifcs.length - 1) continue;
                result.append(',');
            }
            return result.toString();
        }
        if (clazz.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz);
        }
        return clazz.getName();
    }

    public static Pageables<Class<?>, Class<?>> getInterfaces(Class<?> sourceClass) {
        Assert.requiredArgument(sourceClass != null, "sourceClass");
        return new StreamPageables(sourceClass, c -> {
            Class<?>[] interfaces = c.getInterfaces();
            List<Object> list = interfaces == null ? Collections.emptyList() : Arrays.asList(interfaces);
            return new SharedPageable(c, list, c.getSuperclass());
        });
    }

    public static String getPackageName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull((Object)fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static String[] getParentPackageNames(String packageName) {
        if (!StringUtils.hasText(packageName)) {
            return new String[0];
        }
        String[] packageNameArray = StringUtils.splitToArray((CharSequence)packageName, ".");
        String[] array = new String[packageNameArray.length - 1];
        StringBuilder sb = new StringBuilder();
        int len = packageNameArray.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            if (i == len - 1) break;
            sb.append(packageNameArray[i]);
            array[i] = sb.toString();
        }
        return array;
    }

    public static String getQualifiedName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz);
        }
        return clazz.getName();
    }

    private static String getQualifiedNameForArray(Class<?> clazz) {
        StringBuilder result = new StringBuilder();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            result.append(ARRAY_SUFFIX);
        }
        result.insert(0, clazz.getName());
        return result.toString();
    }

    public static String getShortName(Class<?> clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        String shortName = className.substring(lastDotIndex + 1, className.length());
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortNameAsProperty(Class<?> clazz) {
        String shortName = ClassUtils.getShortName(clazz);
        int dotIndex = shortName.lastIndexOf(46);
        shortName = dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
        return Introspector.decapitalize(shortName);
    }

    public static Class<?> getSuperClass(Class<?> clz) {
        Class<?> superClz = clz.getSuperclass();
        if (superClz == null || Object.class.getName().equals(superClz.getName())) {
            return null;
        }
        return superClz;
    }

    public static List<Class<?>> getSuperClassList(Class<?> clz) {
        ArrayList clzList = new ArrayList();
        Class<?> superClz = ClassUtils.getSuperClass(clz);
        while (superClz != null) {
            clzList.add(superClz);
            superClz = ClassUtils.getSuperClass(superClz);
        }
        return clzList;
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Class<?> resolvedWrapper;
        Class<?> resolvedPrimitive;
        Assert.notNull(lhsType, "Left-hand side type must not be null");
        Assert.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        return lhsType.isPrimitive() ? (resolvedPrimitive = primitiveWrapperTypeMap.get(rhsType)) != null && lhsType.equals(resolvedPrimitive) : (resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType)) != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isAssignable(Class<?>[] lhsTypes, Class<?>[] rhsTypes) {
        if (ArrayUtils.isEmpty(lhsTypes)) {
            return ArrayUtils.isEmpty(rhsTypes);
        }
        if (lhsTypes.length != (rhsTypes == null ? 0 : rhsTypes.length)) {
            return false;
        }
        for (int i = 0; i < lhsTypes.length; ++i) {
            if (ClassUtils.isAssignable(lhsTypes[i], rhsTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Collection<Class<?>> lhsTypes, Collection<Class<?>> rhsTypes) {
        if (CollectionUtils.isEmpty(lhsTypes)) {
            return CollectionUtils.isEmpty(rhsTypes);
        }
        if (lhsTypes.size() != (CollectionUtils.isEmpty(rhsTypes) ? 0 : rhsTypes.size())) {
            return false;
        }
        Iterator<Class<?>> lhsIterator = lhsTypes.iterator();
        Iterator<Class<?>> rhsIterator = rhsTypes.iterator();
        while (lhsIterator.hasNext() && rhsIterator.hasNext()) {
            if (ClassUtils.isAssignable(lhsIterator.next(), rhsIterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignableValue(Class<?> type, Object value) {
        Assert.notNull(type, "Type must not be null");
        return value != null ? ClassUtils.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    public static boolean isAvailable(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return JavaVersion.isSupported(clazz);
    }

    public static boolean isBoolean(Type type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    public static boolean isByte(Type type) {
        return type == Byte.TYPE || type == Byte.class;
    }

    public static boolean isCacheSafe(Class<?> clazz, ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        ClassLoader target = clazz.getClassLoader();
        if (target == null) {
            return false;
        }
        ClassLoader cur = classLoader;
        if (cur == target) {
            return true;
        }
        while (cur != null) {
            if ((cur = cur.getParent()) != target) continue;
            return true;
        }
        return false;
    }

    public static boolean isChar(Type type) {
        return type == Character.TYPE || type == Character.class;
    }

    public static boolean isDouble(Type type) {
        return type == Double.TYPE || type == Double.class;
    }

    public static boolean isFloat(Type type) {
        return type == Float.TYPE || type == Float.class;
    }

    public static boolean isInt(Type type) {
        return type == Integer.TYPE || type == Integer.class;
    }

    public static boolean isLong(Type type) {
        return type == Long.TYPE || type == Long.class;
    }

    public static boolean isMultipleValues(Class<?> type) {
        return type != null && (type.isArray() || Collection.class.isAssignableFrom(type));
    }

    public static boolean isPresent(String className, @Nullable ClassLoader classLoader) {
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isPrimitive(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveOrWrapper(Type type) {
        Assert.notNull((Object)type, "Class must not be null");
        return ClassUtils.isPrimitive(type) || ClassUtils.isPrimitiveWrapper(type);
    }

    public static boolean isPrimitiveWrapper(Type type) {
        Assert.notNull((Object)type, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(type);
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static boolean isShort(Type type) {
        return type == Short.TYPE || type == Short.class;
    }

    public static boolean isString(Type type) {
        return type == String.class;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            Class<?> actualClass = classLoader.loadClass(clazz.getName());
            return clazz == actualClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean matchesTypeName(Class<?> clazz, String typeName) {
        return typeName != null && (typeName.equals(clazz.getName()) || typeName.equals(clazz.getSimpleName()) || clazz.isArray() && typeName.equals(ClassUtils.getQualifiedNameForArray(clazz)));
    }

    public static ClassLoader overrideThreadContextClassLoader(ClassLoader classLoaderToUse) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(classLoaderToUse);
            return threadContextClassLoader;
        }
        return null;
    }

    public static boolean sameName(Class<?> left, Class<?> right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return left == null;
        }
        return StringUtils.equals(left.getName(), right.getName());
    }

    private static void registerCommonClasses(Class<?> ... commonClasses) {
        for (Class<?> clazz : commonClasses) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    public static Class<?> resolveClassName(String className, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassUtils.forName(className, classLoader);
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (LinkageError err) {
            throw new IllegalArgumentException("Unresolvable class definition for class [" + className + "]", err);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class [" + className + "]", ex);
        }
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() && clazz != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz) : clazz;
    }

    public static Class<?>[] toClassArray(Collection<Class<?>> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new Class[collection.size()]);
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.isSynthetic() && clazz.getSuperclass() == Object.class && clazz.getInterfaces().length > 0 && clazz.getName().contains("$$Lambda");
    }

    private ClassUtils() {
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry.getValue(), entry.getKey());
            ClassUtils.registerCommonClasses(entry.getKey());
        }
        HashSet<Class<Void>> primitiveTypes = new HashSet<Class<Void>>(64);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        primitiveTypes.addAll(Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassUtils.registerCommonClasses(Enum.class, Iterable.class, Cloneable.class, Comparable.class);
    }
}

