/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.AbstractCursor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ReversibleIterator;
import io.basc.framework.util.RunnableProcessor;
import java.math.BigInteger;
import java.util.function.Function;

public final class ConvertibleCursor<S, T>
extends AbstractCursor<T, ConvertibleCursor<S, T>> {
    private final ReversibleIterator<? extends S> iterator;
    private final Function<? super S, ? extends T> converter;
    private BigInteger position;

    public ConvertibleCursor(ReversibleIterator<? extends S> iterator, Function<? super S, ? extends T> converter, BigInteger position, @Nullable RunnableProcessor<? extends RuntimeException> closeProcessor) {
        super(closeProcessor);
        Assert.requiredArgument(iterator != null, "iterator");
        Assert.requiredArgument(converter != null, "converter");
        Assert.requiredArgument(position != null, "position");
        this.iterator = iterator;
        this.converter = converter;
        this.position = position;
    }

    @Override
    public BigInteger getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        try {
            T t = this.converter.apply(this.iterator.next());
            return t;
        }
        finally {
            this.position = this.position.add(BigInteger.ONE);
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public T previous() {
        try {
            T t = this.converter.apply(this.iterator.previous());
            return t;
        }
        finally {
            this.position = this.position.subtract(BigInteger.ONE);
        }
    }
}

