/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import java.util.Enumeration;
import java.util.function.Function;

public class ConvertibleEnumeration<T, E>
implements Enumeration<E> {
    private Enumeration<? extends T> enumeration;
    private Function<T, E> converter;

    public ConvertibleEnumeration(Enumeration<? extends T> enumeration, Function<T, E> converter) {
        this.enumeration = enumeration;
        this.converter = converter;
    }

    @Override
    public boolean hasMoreElements() {
        return this.enumeration.hasMoreElements();
    }

    @Override
    public E nextElement() {
        T v = this.enumeration.nextElement();
        if (v == null) {
            return null;
        }
        return this.converter.apply(v);
    }

    public static Enumeration<String> convertToStringEnumeration(Enumeration<?> enumeration) {
        return new ConvertibleEnumeration<Object, String>(enumeration, k -> String.valueOf(k));
    }
}

