/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Optional;
import io.basc.framework.util.OptionalLong;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public final class DefaultOptionalLong
implements OptionalLong,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final OptionalLong EMPTY = new DefaultOptionalLong(false, 0L);
    private final boolean present;
    private final long value;

    public DefaultOptionalLong(long value) {
        this(true, value);
    }

    public DefaultOptionalLong(boolean present, long value) {
        this.present = present;
        this.value = value;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public Long get() {
        return this.getAsLong();
    }

    @Override
    public long getAsLong() {
        if (this.present) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    @Override
    public OptionalLong filter(LongPredicate predicate) {
        if (this.isPresent()) {
            return predicate.test(this.value) ? this : EMPTY;
        }
        return this;
    }

    @Override
    public <U> Optional<U> map(LongFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.present) {
            return Optional.of(mapper.apply(this.value));
        }
        return Optional.empty();
    }

    @Override
    public <U> Optional<U> flatMap(LongFunction<Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.present) {
            return Objects.requireNonNull(mapper.apply(this.value));
        }
        return Optional.empty();
    }

    @Override
    public OptionalLong filter(Predicate<? super Long> predicate) {
        if (this.isPresent()) {
            return predicate.test((Long)this.value) ? this : EMPTY;
        }
        return this;
    }

    public String toString() {
        return this.present ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

