/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.DefaultReverseIterator;
import io.basc.framework.util.ReversibleIterator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public final class DefaultReversibleIterator<E>
implements ReversibleIterator<E> {
    private Iterator<? extends E> iterator;

    public DefaultReversibleIterator(List<? extends E> list) {
        Assert.requiredArgument(list != null, "list");
        this.iterator = list.listIterator();
    }

    public DefaultReversibleIterator(Iterator<? extends E> iterator) {
        Assert.requiredArgument(iterator != null, "iterator");
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        this.iterator.forEachRemaining(action);
    }

    @Override
    public boolean hasPrevious() {
        if (this.iterator instanceof ListIterator) {
            return ((ListIterator)this.iterator).hasPrevious();
        }
        if (this.iterator instanceof ReversibleIterator) {
            return ((ReversibleIterator)this.iterator).hasPrevious();
        }
        List list = this.toList();
        this.iterator = list.listIterator(list.size());
        return ((ListIterator)this.iterator).hasPrevious();
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException(DefaultReverseIterator.class.getName() + "#previous");
        }
        if (this.iterator instanceof ListIterator) {
            return ((ListIterator)this.iterator).previous();
        }
        if (this.iterator instanceof ReversibleIterator) {
            return ((ReversibleIterator)this.iterator).previous();
        }
        throw Assert.shouldNeverGetHere();
    }
}

