/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.core.OrderComparator;
import io.basc.framework.util.ConfigurableServiceLoader;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.Cursors;
import io.basc.framework.util.Registration;
import io.basc.framework.util.ServiceLoader;
import io.basc.framework.util.SingletonServiceLoader;
import io.basc.framework.util.StaticSupplier;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.function.Supplier;

public class DefaultServiceLoader<S>
implements ConfigurableServiceLoader<S> {
    private volatile LinkedHashSet<ServiceLoader<S>> serviceLoaders;
    private Comparator<S> comparator = OrderComparator.INSTANCE;

    public final Comparator<S> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<S> comparator) {
        this.comparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (this.serviceLoaders != null) {
            DefaultServiceLoader defaultServiceLoader = this;
            synchronized (defaultServiceLoader) {
                if (this.serviceLoaders != null) {
                    for (ServiceLoader serviceLoader : this.serviceLoaders) {
                        serviceLoader.reload();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor<S> iterator() {
        if (this.serviceLoaders != null) {
            DefaultServiceLoader defaultServiceLoader = this;
            synchronized (defaultServiceLoader) {
                if (this.serviceLoaders != null) {
                    if (this.comparator == null) {
                        return Cursor.of(new Cursors(this.serviceLoaders.stream().map((? super T e) -> e.iterator()).iterator()).stream().distinct());
                    }
                    return Cursor.of(new Cursors(this.serviceLoaders.stream().map((? super T e) -> e.iterator()).iterator()).stream().sorted(this.comparator).distinct());
                }
            }
        }
        return Cursor.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration registerLoader(ServiceLoader<S> serviceLoader) {
        DefaultServiceLoader defaultServiceLoader;
        if (this.serviceLoaders == null) {
            defaultServiceLoader = this;
            synchronized (defaultServiceLoader) {
                if (this.serviceLoaders == null) {
                    this.serviceLoaders = new LinkedHashSet();
                }
            }
        }
        defaultServiceLoader = this;
        synchronized (defaultServiceLoader) {
            if (this.serviceLoaders.contains(serviceLoader)) {
                return Registration.EMPTY;
            }
            this.serviceLoaders.add(serviceLoader);
            return () -> this.unrgister(serviceLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unrgister(ServiceLoader<S> serviceLoader) {
        if (this.serviceLoaders != null) {
            DefaultServiceLoader defaultServiceLoader = this;
            synchronized (defaultServiceLoader) {
                if (this.serviceLoaders != null) {
                    this.serviceLoaders.remove(serviceLoader);
                }
            }
        }
    }

    @Override
    public Registration registerSupplier(Supplier<? extends S> serviceSupplier) {
        SingletonServiceLoader<? extends S> serviceLoader = new SingletonServiceLoader<S>(serviceSupplier, (Object)serviceSupplier);
        return this.registerLoader(serviceLoader);
    }

    @Override
    public Registration register(S service) {
        return this.registerSupplier(new StaticSupplier<S>(service));
    }
}

