/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.Registration;
import java.util.concurrent.atomic.AtomicBoolean;

public class DisposableRegistration
implements Registration {
    private Registration registration;
    private final AtomicBoolean unregistred = new AtomicBoolean(false);

    public DisposableRegistration(Registration registration) {
        Assert.requiredArgument(registration != null, "registration");
        this.registration = registration;
    }

    @Override
    public void unregister() {
        if (!this.isEmpty() && this.unregistred.compareAndSet(false, true)) {
            this.registration.unregister();
        }
    }

    public boolean isUnregistred() {
        return this.unregistred.get();
    }

    @Override
    public Registration disposable() {
        return this;
    }

    @Override
    public Registration and(Registration registration) {
        this.registration = this.registration.and(registration);
        return this;
    }

    public static Registration of(Registration registration) {
        if (registration instanceof DisposableRegistration) {
            return (DisposableRegistration)registration;
        }
        return new DisposableRegistration(registration);
    }
}

