/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Processor;
import java.util.Objects;

public interface DoubleConsumerProcessor<E extends Throwable> {
    public void process(double var1) throws E;

    default public DoubleConsumerProcessor<E> andThen(DoubleConsumerProcessor<? extends E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.process(t);
            after.process(t);
        };
    }

    default public Processor<Double, Void, E> toProcessor() {
        return new Processor<Double, Void, E>(){

            @Override
            public Void process(Double source) throws Throwable {
                DoubleConsumerProcessor.this.process(source);
                return null;
            }
        };
    }

    default public DoubleConsumerProcessor<E> beforeNesting(DoubleConsumerProcessor<E> processor) {
        if (processor == null) {
            return this;
        }
        return t -> {
            try {
                this.process(t);
            }
            finally {
                processor.process(t);
            }
        };
    }

    default public DoubleConsumerProcessor<E> afterNesting(DoubleConsumerProcessor<E> processor) {
        if (processor == null) {
            return this;
        }
        return t -> {
            try {
                processor.process(t);
            }
            finally {
                this.process(t);
            }
        };
    }
}

