/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Inheriter;
import io.basc.framework.util.InheriterBackup;
import io.basc.framework.util.InheriterCapture;
import io.basc.framework.util.InheriterDecorator;
import io.basc.framework.util.Registration;
import java.util.concurrent.CopyOnWriteArraySet;

public class InheriterRegistry<A, B>
extends InheriterDecorator<InheriterCapture<A, B>, InheriterBackup<A, B>> {
    private final CopyOnWriteArraySet<Inheriter<A, B>> registers = new CopyOnWriteArraySet();

    @Override
    public InheriterCapture<A, B> capture() {
        InheriterCapture capture = new InheriterCapture(this.registers.size());
        for (Inheriter<A, B> inheriter : this.registers) {
            capture.put(inheriter, inheriter.capture());
        }
        return capture;
    }

    @Override
    public InheriterBackup<A, B> replay(InheriterCapture<A, B> capture) {
        return capture.replay();
    }

    @Override
    public void restore(InheriterBackup<A, B> backup) {
        backup.restore();
    }

    @Override
    public InheriterBackup<A, B> clear() {
        InheriterBackup backup = new InheriterBackup();
        for (Inheriter<A, B> inheriter : this.registers) {
            backup.put(inheriter, inheriter.clear());
        }
        return backup;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof InheriterRegistry) {
            return this.registers.equals(((InheriterRegistry)obj).registers);
        }
        return false;
    }

    public int hashCode() {
        return this.registers.hashCode();
    }

    public String toString() {
        return this.registers.toString();
    }

    public Registration register(Inheriter<A, B> inheriter) {
        return this.registers.add(inheriter) ? () -> this.registers.remove(inheriter) : Registration.EMPTY;
    }

    public Registration unregister(Inheriter<A, B> inheriter) {
        return this.registers.remove(inheriter) ? () -> this.registers.add(inheriter) : Registration.EMPTY;
    }
}

