/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class IterationIterator<S, T>
implements Iterator<T> {
    private final Iterator<? extends S> iterator;
    private final Function<? super S, ? extends Iterator<T>> converter;
    private Iterator<? extends T> valueIterator;

    public IterationIterator(Iterator<? extends S> iterator, Function<? super S, ? extends Iterator<T>> converter) {
        Assert.requiredArgument(iterator != null, "iterator");
        Assert.requiredArgument(converter != null, "converter");
        this.iterator = iterator;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        if (this.valueIterator == null) {
            if (!this.iterator.hasNext()) {
                return false;
            }
            S s = this.iterator.next();
            this.valueIterator = this.converter.apply(s);
        }
        if (this.valueIterator.hasNext()) {
            return true;
        }
        if (this.iterator.hasNext()) {
            this.valueIterator = null;
            return this.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.valueIterator.next();
    }
}

