/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.io.IOUtils;
import io.basc.framework.util.StringUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class JarUtils {
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_CLASS_PATH_NAME = "Class-Path";

    public static Map<String, String> formatManifestFile(JarFile jarFile) {
        JarEntry jarEntry = jarFile.getJarEntry(MANIFEST);
        if (jarEntry == null) {
            return Collections.EMPTY_MAP;
        }
        InputStream inputStream = null;
        try {
            inputStream = jarFile.getInputStream(jarEntry);
            return JarUtils.formatManifestFile(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_MAP;
        }
    }

    private static Map<String, String> formatManifestFile(InputStream inputStream) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        List list = IOUtils.readLines(inputStream).toList();
        for (String content : list) {
            int index;
            if (StringUtils.isEmpty(content = content.trim()) || (index = content.indexOf(":")) == -1) continue;
            String name = content.substring(0, index);
            String value = content.substring(index + 1);
            value = value.trim();
            map.put(name, value);
        }
        return map;
    }

    public static String getManifestClassPath(JarFile jarFile) {
        Map<String, String> map = JarUtils.formatManifestFile(jarFile);
        return map.get(MANIFEST_CLASS_PATH_NAME);
    }

    public static String[] getgetManifestClassPaths(JarFile jarFile) {
        String classPath = JarUtils.getManifestClassPath(jarFile);
        return StringUtils.isEmpty(classPath) ? new String[]{} : StringUtils.splitToArray((CharSequence)classPath, " ");
    }

    public static String findEntryName(JarFile jarFile, String searchName) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry == null) continue;
            String name = jarEntry.getName();
            if (!(name = name.replaceAll("\\\\", "/")).endsWith(searchName)) continue;
            return jarEntry.getName();
        }
        return null;
    }
}

