/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.env.BascObject;
import io.basc.framework.lang.LinkedThreadLocal;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Pair;
import io.basc.framework.util.StringUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class Keywords
extends BascObject
implements Predicate<String>,
Iterable<String>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final LinkedThreadLocal<Object> NESTED = new LinkedThreadLocal(Keywords.class.getName());
    public static final KeywordStrategy HUMP = new HumpKeywordStrategy(true);
    public static final KeywordStrategy ORIGINAL = new OriginalKeywordStrategy(false);
    private final KeywordStrategy strategy;
    private final LinkedList<String> keywords = new LinkedList();
    private final Keywords parent;
    private Predicate<String> predicate;

    public Keywords(KeywordStrategy strategy) {
        this(null, strategy);
    }

    public Keywords(Keywords parent, KeywordStrategy strategy) {
        this(parent, strategy, new String[0]);
    }

    public Keywords(KeywordStrategy strategy, String ... keywords) {
        this(null, strategy, keywords);
    }

    public Keywords(Keywords parent, KeywordStrategy strategy, String ... keywords) {
        this.strategy = strategy;
        this.parent = parent;
        if (keywords != null && keywords.length != 0) {
            for (String s : keywords) {
                this.addLast(s);
            }
        }
    }

    @Override
    public Keywords clone() {
        return this.clone(false);
    }

    public Keywords clone(boolean cloneParent) {
        Keywords keywords = new Keywords(cloneParent ? this.parent.clone() : this.parent, this.strategy);
        keywords.keywords.addAll(this.keywords);
        keywords.predicate = this.predicate;
        return keywords;
    }

    @Override
    public Iterator<String> iterator() {
        return this.keywords.iterator();
    }

    public Stream<String> stream() {
        return this.keywords.stream();
    }

    public Stream<String> streamAll() {
        if (this.parent == null) {
            return this.stream();
        }
        return Stream.concat(this.stream(), this.parent.streamAll());
    }

    @Nullable
    public Keywords getParent() {
        return this.parent;
    }

    public Keywords clearAll() {
        Keywords keyword = this;
        while (keyword != null) {
            keyword.clear();
            keyword = keyword.parent;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keywords clear() {
        LinkedList<String> linkedList = this.keywords;
        synchronized (linkedList) {
            this.keywords.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keywords addFirst(String key) {
        String keyUse = this.strategy.format(key);
        Assert.requiredArgument(this.test(keyUse), "key");
        LinkedList<String> linkedList = this.keywords;
        synchronized (linkedList) {
            this.keywords.addFirst(keyUse);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keywords addLast(String key) {
        String keyUse = this.strategy.format(key);
        Assert.requiredArgument(this.test(keyUse), "key");
        LinkedList<String> linkedList = this.keywords;
        synchronized (linkedList) {
            this.keywords.addLast(keyUse);
        }
        return this;
    }

    public Predicate<String> getPredicate() {
        return this.predicate;
    }

    public Keywords setPredicate(Predicate<String> predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public boolean test(String key) {
        if (this.keywords.stream().filter(e -> this.strategy.test((String)e, key) || this.strategy.test(key, (String)e)).findAny().isPresent()) {
            return false;
        }
        if (this.predicate != null && !NESTED.isCurrent(this.predicate) && !NESTED.isCurrent(this)) {
            try {
                NESTED.set(this.predicate);
                NESTED.set(this);
                if (!this.predicate.test(key)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                NESTED.remove(this);
                NESTED.remove(this.predicate);
            }
        }
        return this.parent == null || this.parent.test(key);
    }

    public boolean exists(String key) {
        return this.parent != null && this.parent.exists(key) || this.keywords.stream().filter(e -> this.strategy.exists((String)e, key)).findAny().isPresent();
    }

    public Pair<String, Integer> indexOf(String express) {
        Pair index = Pair.process(this.keywords, e -> express.indexOf((String)e), e -> (Integer)e.getValue() != -1).orElse(null);
        if (index == null && this.parent != null) {
            return this.parent.indexOf(express);
        }
        return index;
    }

    public String getFirst() {
        if (this.parent != null) {
            return this.parent.getFirst();
        }
        return this.keywords.getFirst();
    }

    public String getLast() {
        if (this.keywords.isEmpty() && this.parent != null) {
            return this.parent.getLast();
        }
        return this.keywords.getLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keywords removeFirst() {
        LinkedList<String> linkedList = this.keywords;
        synchronized (linkedList) {
            this.keywords.removeFirst();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keywords removeLast() {
        LinkedList<String> linkedList = this.keywords;
        synchronized (linkedList) {
            this.keywords.removeLast();
        }
        return this;
    }

    public static interface KeywordStrategy {
        public String format(String var1);

        public boolean test(String var1, String var2);

        public boolean exists(String var1, String var2);
    }

    public static abstract class AbstractKeywordStrategy
    implements KeywordStrategy,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean ignoreCase;

        public AbstractKeywordStrategy(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        @Override
        public boolean test(String left, String right) {
            return StringUtils.contains(left, right, this.isIgnoreCase());
        }

        @Override
        public boolean exists(String left, String right) {
            return StringUtils.equals(left, right, this.isIgnoreCase());
        }
    }

    private static class OriginalKeywordStrategy
    extends AbstractKeywordStrategy {
        private static final long serialVersionUID = 1L;

        public OriginalKeywordStrategy(boolean ignoreCase) {
            super(ignoreCase);
        }

        @Override
        public String format(String key) {
            return key;
        }

        @Override
        public boolean test(String left, String right) {
            return StringUtils.equals(left, right, this.isIgnoreCase());
        }
    }

    private static class HumpKeywordStrategy
    extends AbstractKeywordStrategy {
        private static final long serialVersionUID = 1L;

        public HumpKeywordStrategy(boolean ignoreCase) {
            super(ignoreCase);
        }

        @Override
        public String format(String key) {
            return StringUtils.toUpperCase(key, 0, 1);
        }
    }
}

