/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRULinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int maxCapacity;

    public LRULinkedHashMap(int maxCapacity) {
        this(maxCapacity, maxCapacity + 1, 1.0f);
    }

    public LRULinkedHashMap(int maxCapacity, int initialCapacity, float loadFactor) {
        this(maxCapacity, initialCapacity, loadFactor, false);
    }

    public LRULinkedHashMap(int maxCapacity, int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxCapacity = maxCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    @Override
    protected final boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.getMaxCapacity();
    }
}

